/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.provider;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1661;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2527;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_408;
import net.minecraft.class_445;
import net.minecraft.class_465;
import net.minecraft.class_9928;
import org.apache.commons.lang3.tuple.Triple;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.glfw.GLFW;
import org.vivecraft.api.client.data.CloseKeyboardContext;
import org.vivecraft.api.client.data.RenderPass;
import org.vivecraft.api.data.VRBodyPart;
import org.vivecraft.client.VivecraftVRMod;
import org.vivecraft.client.network.ClientNetworking;
import org.vivecraft.client.utils.ClientUtils;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.QuaternionfHistory;
import org.vivecraft.client_vr.VRData;
import org.vivecraft.client_vr.Vector3fHistory;
import org.vivecraft.client_vr.extensions.GuiExtension;
import org.vivecraft.client_vr.extensions.WindowExtension;
import org.vivecraft.client_vr.gameplay.screenhandlers.GuiHandler;
import org.vivecraft.client_vr.gameplay.screenhandlers.KeyboardHandler;
import org.vivecraft.client_vr.gameplay.screenhandlers.RadialHandler;
import org.vivecraft.client_vr.gameplay.trackers.ClimbTracker;
import org.vivecraft.client_vr.provider.ActionParams;
import org.vivecraft.client_vr.provider.ControllerType;
import org.vivecraft.client_vr.provider.DeviceSource;
import org.vivecraft.client_vr.provider.HapticScheduler;
import org.vivecraft.client_vr.provider.HardwareType;
import org.vivecraft.client_vr.provider.InputSimulator;
import org.vivecraft.client_vr.provider.VRRenderer;
import org.vivecraft.client_vr.provider.openvr_lwjgl.VRInputAction;
import org.vivecraft.client_vr.provider.openvr_lwjgl.control.VRInputActionSet;
import org.vivecraft.client_vr.render.RenderConfigException;
import org.vivecraft.client_vr.settings.AutoCalibration;
import org.vivecraft.client_vr.settings.VRHotkeys;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.client_vr.utils.osc_trackers.OSCTracker;
import org.vivecraft.client_vr.utils.osc_trackers.OSCTrackerReceiver;
import org.vivecraft.common.utils.MathUtils;

public abstract class MCVR {
    public static final int MAIN_CONTROLLER = 0;
    public static final int OFFHAND_CONTROLLER = 1;
    public static final int RIGHT_CONTROLLER = 0;
    public static final int LEFT_CONTROLLER = 1;
    public static final int CAMERA_TRACKER = 2;
    public static final int WAIST_TRACKER = 3;
    public static final int RIGHT_FOOT_TRACKER = 4;
    public static final int LEFT_FOOT_TRACKER = 5;
    public static final int RIGHT_ELBOW_TRACKER = 6;
    public static final int LEFT_ELBOW_TRACKER = 7;
    public static final int RIGHT_KNEE_TRACKER = 8;
    public static final int LEFT_KNEE_TRACKER = 9;
    public static final int TRACKABLE_DEVICE_COUNT = 10;
    protected class_310 mc;
    protected ClientDataHolderVR dh;
    protected static MCVR ME;
    protected static VivecraftVRMod MOD;
    protected HardwareType detectedHardware = HardwareType.VIVE;
    protected Matrix4f hmdPose = new Matrix4f();
    public Matrix4f hmdRotation = new Matrix4f();
    protected Matrix4f hmdPoseLeftEye = new Matrix4f();
    protected Matrix4f hmdPoseRightEye = new Matrix4f();
    public Vector3fHistory hmdHistory = new Vector3fHistory();
    public Vector3fHistory hmdPivotHistory = new Vector3fHistory();
    public QuaternionfHistory hmdRotHistory = new QuaternionfHistory();
    protected boolean headIsTracking;
    protected Matrix4f[] controllerPose = new Matrix4f[10];
    protected Matrix4f[] controllerRotation = new Matrix4f[10];
    protected boolean[] controllerTracking = new boolean[10];
    protected Matrix4f[] handRotation = new Matrix4f[10];
    public final OSCTrackerReceiver oscTrackers;
    protected final DeviceSource[] deviceSource = new DeviceSource[10];
    protected boolean usingUnlabeledTrackers = false;
    public Vector3fHistory[] controllerHistory = new Vector3fHistory[]{new Vector3fHistory(), new Vector3fHistory()};
    public Vector3fHistory[] controllerForwardHistory = new Vector3fHistory[]{new Vector3fHistory(), new Vector3fHistory()};
    public Vector3fHistory[] controllerUpHistory = new Vector3fHistory[]{new Vector3fHistory(), new Vector3fHistory()};
    protected float gunAngle = 0.0f;
    protected boolean gunStyle;
    public boolean initialized;
    public String initStatus;
    public boolean initSuccess;
    protected Matrix4f[] poseMatrices;
    protected Vector3f[] deviceVelocity;
    protected Vector3f[] aimSource = new Vector3f[10];
    private static final int HMD_AVG_MAX_SAMPLES = 90;
    public LinkedList<Vector3f> hmdPosSamples = new LinkedList();
    public LinkedList<Float> hmdYawSamples = new LinkedList();
    protected float hmdYawTotal;
    protected float hmdYawLast;
    protected boolean trigger;
    public boolean mrMovingCamActive;
    protected HapticScheduler hapticScheduler;
    public float seatedRot;
    public float aimPitch = 0.0f;
    protected int moveModeSwitchCount = 0;
    public boolean isWalkingAbout;
    protected boolean isFreeRotate;
    protected boolean isFlickStick;
    protected float flickStickRot;
    public boolean isMovement;
    private boolean wasMovement;
    private boolean wasAutoSprinting;
    public Vector2f movement = new Vector2f();
    protected ControllerType walkaboutController;
    protected ControllerType freeRotateController;
    protected float walkaboutYawStart;
    protected float hmdForwardYaw = 180.0f;
    public boolean ignorePressesNextFrame = false;
    protected int quickTorchPreviousSlot;
    protected Map<String, VRInputAction> inputActions = new HashMap<String, VRInputAction>();
    protected Map<String, VRInputAction> inputActionsByKeyBinding = new HashMap<String, VRInputAction>();
    protected static final Vector3fc[] FBT_REFERENCE_POSITIONS;

    public MCVR(class_310 mc, ClientDataHolderVR dh, VivecraftVRMod vrMod) {
        this.mc = mc;
        this.dh = dh;
        MOD = vrMod;
        ME = this;
        for (int c = 0; c < 10; ++c) {
            this.aimSource[c] = new Vector3f();
            this.controllerPose[c] = new Matrix4f();
            this.controllerRotation[c] = new Matrix4f();
            this.handRotation[c] = new Matrix4f();
            this.deviceSource[c] = new DeviceSource(DeviceSource.Source.NULL);
        }
        this.oscTrackers = new OSCTrackerReceiver(this);
    }

    public static MCVR get() {
        return ME;
    }

    public abstract boolean init() throws RenderConfigException;

    public void destroy() {
        this.oscTrackers.stop();
        ME = null;
    }

    public void triggerHapticPulse(ControllerType controller, float durationSeconds, float frequency, float amplitude) {
        this.triggerHapticPulse(controller, durationSeconds, frequency, amplitude, 0.0f);
    }

    public void triggerHapticPulse(VRBodyPart bodyPart, float durationSeconds, float frequency, float amplitude, float delaySeconds) {
        if (!bodyPart.isHand()) {
            return;
        }
        this.triggerHapticPulse(bodyPart == VRBodyPart.MAIN_HAND ? ControllerType.RIGHT : ControllerType.LEFT, durationSeconds, frequency, amplitude, delaySeconds);
    }

    public void triggerHapticPulse(ControllerType controller, float durationSeconds, float frequency, float amplitude, float delaySeconds) {
        if (this.dh.vrSettings.seated) {
            return;
        }
        if (this.dh.vrSettings.reverseHands) {
            controller = controller == ControllerType.RIGHT ? ControllerType.LEFT : ControllerType.RIGHT;
        }
        this.hapticScheduler.queueHapticPulse(controller, durationSeconds, frequency, amplitude, delaySeconds);
    }

    @Deprecated
    public void triggerHapticPulse(ControllerType controller, int strength) {
        if (strength >= 1) {
            this.triggerHapticPulse(controller, (float)strength / 1000000.0f, 160.0f, 1.0f);
        }
    }

    @Deprecated
    public void triggerHapticPulse(int controller, int strength) {
        if (controller >= 0 && controller < ControllerType.values().length) {
            this.triggerHapticPulse(ControllerType.values()[controller], strength);
        }
    }

    @Deprecated
    protected void triggerBindingHapticPulse(class_304 keyMapping, int strength) {
        ControllerType controller = this.findActiveBindingControllerType(keyMapping);
        if (controller != null) {
            this.triggerHapticPulse(controller, strength);
        }
    }

    public float getGunAngle() {
        return this.gunAngle;
    }

    public Matrix4fc getAimRotation(int controller) {
        return this.controllerRotation[controller];
    }

    public Vector3fc getAimSource(int controller) {
        Vector3f out = this.aimSource[controller];
        if (!this.dh.vrSettings.seated && this.dh.vrSettings.allowStandingOriginOffset && this.dh.vr.isHMDTracking()) {
            return out.add((Vector3fc)this.dh.vrSettings.originOffset, new Vector3f());
        }
        return out;
    }

    public Vector3f getAimVector(int controller) {
        return this.controllerRotation[controller].transformDirection(MathUtils.BACK, new Vector3f());
    }

    public Matrix4fc getHandRotation(int controller) {
        return this.handRotation[controller];
    }

    public Vector3f getHandVector(int controller) {
        return this.handRotation[controller].transformDirection(MathUtils.BACK, new Vector3f());
    }

    public Vector3f getEyePosition(RenderPass eye) {
        Matrix4f pose = new Matrix4f((Matrix4fc)this.hmdPose);
        switch (eye) {
            case LEFT: {
                pose.mul((Matrix4fc)this.hmdPoseLeftEye);
                break;
            }
            case RIGHT: {
                pose.mul((Matrix4fc)this.hmdPoseRightEye);
                break;
            }
        }
        Vector3f pos = pose.getTranslation(new Vector3f());
        if ((this.dh.vrSettings.seated || this.dh.vrSettings.allowStandingOriginOffset) && this.dh.vr.isHMDTracking()) {
            pos = pos.add((Vector3fc)this.dh.vrSettings.originOffset);
        }
        return pos;
    }

    public Matrix4fc getEyeRotation(RenderPass eye) {
        Matrix4f hmdToEye;
        switch (eye) {
            case LEFT: {
                Matrix4f matrix4f = this.hmdPoseLeftEye;
                break;
            }
            case RIGHT: {
                Matrix4f matrix4f = this.hmdPoseRightEye;
                break;
            }
            default: {
                Matrix4f matrix4f = hmdToEye = null;
            }
        }
        if (hmdToEye != null) {
            Matrix4f eyeRot = new Matrix4f().set3x3((Matrix4fc)hmdToEye);
            return this.hmdRotation.mul((Matrix4fc)eyeRot, eyeRot);
        }
        return this.hmdRotation;
    }

    public Vector3f getHmdVector() {
        return this.hmdRotation.transformDirection(MathUtils.BACK, new Vector3f());
    }

    public VRInputAction getInputAction(class_304 keyMapping) {
        return this.getInputAction(keyMapping.method_1431());
    }

    public VRInputAction getInputAction(String name) {
        return this.inputActionsByKeyBinding.get(name);
    }

    public VRInputAction getInputActionByName(String name) {
        return this.inputActions.get(name);
    }

    public Collection<VRInputAction> getInputActions() {
        return Collections.unmodifiableCollection(this.inputActions.values());
    }

    public Collection<VRInputAction> getInputActionsInSet(VRInputActionSet set) {
        return Collections.unmodifiableCollection(this.inputActions.values().stream().filter(action -> action.actionSet == set).collect(Collectors.toList()));
    }

    public boolean isControllerTracking(ControllerType controller) {
        return this.isControllerTracking(controller.ordinal());
    }

    public boolean isControllerTracking(int controller) {
        return this.controllerTracking[controller];
    }

    public boolean isHMDTracking() {
        return this.headIsTracking;
    }

    public void resetPosition() {
        this.dh.vrSettings.originOffset.sub((Vector3fc)this.getEyePosition(RenderPass.CENTER));
        this.dh.vrSettings.originOffset.y += 1.62f;
    }

    public void clearOffset() {
        this.dh.vrSettings.originOffset.zero();
    }

    protected void changeHotbar(int dir) {
        if (!(this.mc.field_1724 == null || this.dh.climbTracker.isGrabbingLadder() && ClimbTracker.isClaws(this.mc.field_1724.method_6047()))) {
            if (this.mc.field_1755 == null) {
                InputSimulator.scrollMouse(0.0, dir * 4);
            } else {
                this.mc.field_1724.method_31548().method_61496(class_9928.method_61972((double)dir, (int)this.mc.field_1724.method_31548().method_67532(), (int)class_1661.method_7368()));
            }
        }
    }

    protected class_304 findKeyBinding(String name) {
        return Stream.concat(Arrays.stream(this.mc.field_1690.field_1839), MOD.getHiddenKeyBindings().stream()).filter(kb -> name.equals(kb.method_1431())).findFirst().orElse(null);
    }

    protected void hmdSampling() {
        if (this.hmdPosSamples.size() == 90) {
            this.hmdPosSamples.removeFirst();
        }
        if (this.hmdYawSamples.size() == 90) {
            this.hmdYawSamples.removeFirst();
        }
        this.hmdPosSamples.add(this.dh.vrPlayer.vrdata_room_pre.hmd.getPositionF());
        float yaw = this.dh.vrPlayer.vrdata_room_pre.hmd.getYaw();
        if (yaw < 0.0f) {
            yaw += 360.0f;
        }
        this.hmdYawTotal += MathUtils.angleDiff(yaw, this.hmdYawLast);
        this.hmdYawLast = yaw;
        if (Math.abs(MathUtils.angleNormalize(this.hmdYawTotal) - this.hmdYawLast) > 1.0f || this.hmdYawTotal > 100000.0f) {
            this.hmdYawTotal = this.hmdYawLast;
            VRSettings.LOGGER.info("Vivecraft: HMD yaw desync/overflow corrected");
        }
        float yawAvg = 0.0f;
        if (!this.hmdYawSamples.isEmpty()) {
            Iterator iterator = this.hmdYawSamples.iterator();
            while (iterator.hasNext()) {
                float sample = ((Float)iterator.next()).floatValue();
                yawAvg += sample;
            }
            yawAvg /= (float)this.hmdYawSamples.size();
        }
        if (Math.abs(this.hmdYawTotal - yawAvg) > 20.0f) {
            this.trigger = true;
        }
        if (Math.abs(this.hmdYawTotal - yawAvg) < 1.0f) {
            this.trigger = false;
        }
        if (this.trigger || this.hmdYawSamples.isEmpty()) {
            this.hmdYawSamples.add(Float.valueOf(this.hmdYawTotal));
        }
    }

    protected void updateAim() {
        this.hmdRotation.identity();
        this.hmdRotation.set3x3((Matrix4fc)this.hmdPose);
        Vector3f eye = this.getEyePosition(RenderPass.CENTER);
        this.hmdHistory.add((Vector3fc)eye);
        Vector3f pivot = this.hmdRotation.transformPosition(new Vector3f(0.0f, -0.1f, 0.1f)).add((Vector3fc)eye);
        this.hmdPivotHistory.add((Vector3fc)pivot);
        this.hmdRotHistory.add(new Quaternionf().setFromNormalized((Matrix4fc)this.hmdRotation).conjugate().rotateY((float)Math.PI / 180 * -this.dh.vrSettings.worldRotation));
        for (int c = 0; c < 2; ++c) {
            Matrix4f controllerPoseTip;
            Matrix4f controllerPoseHand;
            if (this.dh.vrSettings.seated) {
                this.controllerPose[c] = new Matrix4f((Matrix4fc)this.hmdPose);
                controllerPoseHand = this.controllerPose[c];
                controllerPoseTip = this.controllerPose[c];
            } else {
                controllerPoseHand = this.controllerPose[c].mul(this.getControllerComponentTransform(c, "handgrip"), new Matrix4f());
                controllerPoseTip = this.controllerPose[c].mul(this.getControllerComponentTransform(c, "tip"), new Matrix4f());
            }
            this.handRotation[c].identity();
            this.handRotation[c].set3x3((Matrix4fc)controllerPoseHand);
            controllerPoseTip.getTranslation(this.aimSource[c]);
            this.controllerHistory[c].add((Vector3fc)new Vector3f(this.getAimSource(c)));
            this.controllerRotation[c].identity();
            this.controllerRotation[c].set3x3((Matrix4fc)controllerPoseTip);
            if (c == 0 && this.dh.vrSettings.seated && this.mc.field_1755 == null && this.mc.field_1729.method_1613()) {
                Matrix4f temp = new Matrix4f();
                float hRange = 110.0f;
                float vRange = 180.0f;
                int screenWidth = this.mc.method_22683().method_4480();
                int screenHeight = this.mc.method_22683().method_4507();
                if (screenHeight % 2 != 0) {
                    --screenHeight;
                }
                float hPos = (float)this.mc.field_1729.method_1603() / (float)screenWidth * 110.0f - 55.0f;
                float vPos = (float)(-this.mc.field_1729.method_1604()) / (float)screenHeight * 180.0f + 90.0f;
                float rotStart = this.dh.vrSettings.keyholeX;
                float rotSpeed = 20.0f * this.dh.vrSettings.xSensitivity;
                int leftEdge = (int)((-rotStart + 55.0f) * (float)screenWidth / 110.0f) + 1;
                int rightEdge = (int)((rotStart + 55.0f) * (float)screenWidth / 110.0f) - 1;
                float rotMul = (Math.abs(hPos) - rotStart) / (55.0f - rotStart);
                double xPos = this.mc.field_1729.method_1603();
                Vector3f hmdDir = this.getHmdVector();
                if (hPos < -rotStart) {
                    this.seatedRot += rotSpeed * rotMul;
                    this.seatedRot %= 360.0f;
                    this.hmdForwardYaw = (float)Math.toDegrees(Math.atan2(-hmdDir.x, hmdDir.z));
                    xPos = leftEdge;
                    hPos = -rotStart;
                } else if (hPos > rotStart) {
                    this.seatedRot -= rotSpeed * rotMul;
                    this.seatedRot %= 360.0f;
                    this.hmdForwardYaw = (float)Math.toDegrees(Math.atan2(-hmdDir.x, hmdDir.z));
                    xPos = rightEdge;
                    hPos = rotStart;
                }
                float ySpeed = 0.5f * this.dh.vrSettings.ySensitivity;
                this.aimPitch = class_3532.method_15363((float)(this.aimPitch + vPos * ySpeed), (float)-89.9f, (float)89.9f);
                double screenX = xPos * ((double)((WindowExtension)this.mc.method_22683()).vivecraft$getActualScreenWidth() / (double)screenWidth);
                double screenY = (double)((float)screenHeight * 0.5f) * ((double)((WindowExtension)this.mc.method_22683()).vivecraft$getActualScreenHeight() / (double)this.mc.method_22683().method_4507());
                InputSimulator.setMousePos(screenX, screenY);
                GLFW.glfwSetCursorPos((long)this.mc.method_22683().method_4490(), (double)screenX, (double)screenY);
                if (this.dh.vrSettings.aimDevice == VRSettings.AimDevice.CONTROLLER) {
                    temp.rotationY((float)Math.PI / 180 * (-180.0f - hPos - this.hmdForwardYaw));
                    temp.rotateX((float)Math.PI / 180 * this.aimPitch);
                    this.handRotation[c].set((Matrix4fc)this.controllerRotation[c].set3x3((Matrix4fc)temp));
                }
            } else if (c == 0) {
                this.aimPitch = 0.0f;
            }
            this.controllerForwardHistory[c].add((Vector3fc)this.getAimVector(c));
            this.controllerUpHistory[c].add((Vector3fc)this.controllerRotation[c].transformDirection(MathUtils.UP, new Vector3f()));
        }
        if (this.dh.vrSettings.seated) {
            this.aimSource[0] = this.getEyePosition(RenderPass.CENTER);
            this.aimSource[1].set((Vector3fc)this.aimSource[0]);
        }
        if (this.dh.vrSettings.debugCameraTracker) {
            this.controllerPose[2].set((Matrix4fc)this.controllerPose[0]);
        }
        this.controllerRotation[2].identity();
        this.controllerRotation[2].set3x3((Matrix4fc)this.controllerPose[2]);
        if ((this.dh.vrSettings.debugCameraTracker || this.hasCameraTracker()) && (this.dh.vrSettings.displayMirrorMode == VRSettings.MirrorMode.MIXED_REALITY || this.dh.vrSettings.displayMirrorMode == VRSettings.MirrorMode.THIRD_PERSON)) {
            this.mrMovingCamActive = true;
            this.controllerPose[2].getTranslation(this.aimSource[2]);
        } else {
            this.mrMovingCamActive = false;
            this.aimSource[2].set((Vector3fc)this.dh.vrSettings.vrFixedCampos);
        }
        if (this.hasFBT()) {
            int trackers = this.hasExtendedFBT() ? 10 : 6;
            boolean calibrated = this.dh.vrSettings.fbtCalibrated || this.hasExtendedFBT() && this.dh.vrSettings.fbtExtendedCalibrated;
            for (int i = 3; i < trackers; ++i) {
                if (this.deviceSource[i].source == DeviceSource.Source.OSC) {
                    if (this.oscTrackers.trackers[this.deviceSource[i].deviceIndex].isTracking()) {
                        this.controllerPose[i].set((Matrix4fc)this.oscTrackers.trackers[this.deviceSource[i].deviceIndex].pose);
                    } else {
                        this.deviceSource[i].reset();
                    }
                }
                this.controllerRotation[i].set3x3((Matrix4fc)this.controllerPose[i]);
                this.controllerPose[i].getTranslation(this.aimSource[i]);
                if (!calibrated) continue;
                this.controllerRotation[i].rotate((Quaternionfc)this.dh.vrSettings.fbtRotations[i - 3]);
                this.aimSource[i].add((Vector3fc)this.controllerRotation[i].transformDirection((Vector3fc)this.dh.vrSettings.fbtOffsets[i - 3], new Vector3f()));
            }
        }
    }

    public void processBindings() {
        ControllerType controller;
        VRHotkeys.Triggerer trigger;
        ControllerType controller2;
        boolean sleeping = this.mc.field_1687 != null && this.mc.field_1724 != null && this.mc.field_1724.method_6113();
        boolean gui = this.mc.field_1755 != null;
        boolean toggleMovementPressed = MCVR.MOD.keyToggleMovement.method_1436();
        if (this.mc.field_1690.field_1871.method_1434() || toggleMovementPressed) {
            if ((++this.moveModeSwitchCount == 80 || toggleMovementPressed) && ClientNetworking.SERVER_ALLOWS_DIRECT_TELEPORT) {
                if (this.dh.vrSettings.seated) {
                    this.dh.vrSettings.seatedFreeMove = !this.dh.vrSettings.seatedFreeMove;
                    ClientUtils.addChatMessage((class_2561)class_2561.method_43469((String)"vivecraft.messages.movementmodeswitch", (Object[])new Object[]{this.dh.vrSettings.seatedFreeMove ? class_2561.method_43471((String)"vivecraft.options.freemove") : class_2561.method_43471((String)"vivecraft.options.teleport")}));
                } else if (this.dh.vrPlayer.isTeleportSupported()) {
                    this.dh.vrSettings.forceStandingFreeMove = !this.dh.vrSettings.forceStandingFreeMove;
                    ClientUtils.addChatMessage((class_2561)class_2561.method_43469((String)"vivecraft.messages.movementmodeswitch", (Object[])new Object[]{this.dh.vrSettings.seatedFreeMove ? class_2561.method_43471((String)"vivecraft.options.freemove") : class_2561.method_43471((String)"vivecraft.options.teleport")}));
                } else if (this.dh.vrPlayer.isTeleportOverridden()) {
                    this.dh.vrPlayer.setTeleportOverride(false);
                    ClientUtils.addChatMessage((class_2561)class_2561.method_43471((String)"vivecraft.messages.teleportdisabled"));
                } else {
                    this.dh.vrPlayer.setTeleportOverride(true);
                    ClientUtils.addChatMessage((class_2561)class_2561.method_43471((String)"vivecraft.messages.teleportenabled"));
                }
            }
        } else {
            this.moveModeSwitchCount = 0;
        }
        Vector3f main = this.getAimVector(0);
        Vector3f off = this.getAimVector(1);
        float mainYaw = (float)Math.toDegrees(Math.atan2(-main.x, main.z));
        float offYaw = (float)Math.toDegrees(Math.atan2(-off.x, off.z));
        if (!gui) {
            float yaw;
            ControllerType controller3;
            if (MCVR.MOD.keyWalkabout.method_1434()) {
                controller3 = this.findActiveBindingControllerType(MCVR.MOD.keyWalkabout);
                float f = yaw = controller3 == ControllerType.LEFT ? offYaw : mainYaw;
                if (!this.isWalkingAbout) {
                    this.isWalkingAbout = true;
                    this.walkaboutYawStart = this.dh.vrSettings.worldRotation - yaw;
                } else {
                    this.dh.vrSettings.worldRotation = this.walkaboutYawStart + yaw;
                    this.dh.vrSettings.worldRotation %= 360.0f;
                }
            } else {
                this.isWalkingAbout = false;
            }
            if (MCVR.MOD.keyRotateFree.method_1434()) {
                controller3 = this.findActiveBindingControllerType(MCVR.MOD.keyRotateFree);
                float f = yaw = controller3 == ControllerType.LEFT ? offYaw : mainYaw;
                if (!this.isFreeRotate) {
                    this.isFreeRotate = true;
                    this.walkaboutYawStart = this.dh.vrSettings.worldRotation + yaw;
                } else {
                    this.dh.vrSettings.worldRotation = this.walkaboutYawStart - yaw;
                }
            } else {
                this.isFreeRotate = false;
            }
        }
        if (this.dh.vrSettings.worldRotationIncrement == 0.0f) {
            float ax = this.getInputAction(MCVR.MOD.keyRotateAxis).getAxis2DUseTracked().x();
            if (ax == 0.0f) {
                ax = this.getInputAction(MCVR.MOD.keyFreeMoveRotate).getAxis2DUseTracked().x();
            }
            ax -= Math.abs(this.getInputAction(MCVR.MOD.keyRotateLeft).getAxis1DUseTracked());
            if ((ax += Math.abs(this.getInputAction(MCVR.MOD.keyRotateRight).getAxis1DUseTracked())) != 0.0f) {
                float analogRotSpeed = this.dh.vrSettings.worldRotationXSensitivity * 10.0f * ax;
                this.dh.vrSettings.worldRotation -= analogRotSpeed;
                this.dh.vrSettings.worldRotation %= 360.0f;
            }
        } else if (MCVR.MOD.keyRotateAxis.method_1436() || MCVR.MOD.keyFreeMoveRotate.method_1436()) {
            float ax = this.getInputAction(MCVR.MOD.keyRotateAxis).getAxis1D(false);
            if (ax == 0.0f) {
                ax = this.getInputAction(MCVR.MOD.keyFreeMoveRotate).getAxis1D(false);
            }
            if (Math.abs(ax) > 0.5f) {
                this.dh.vrSettings.worldRotation -= this.dh.vrSettings.worldRotationIncrement * Math.signum(ax);
                this.dh.vrSettings.worldRotation %= 360.0f;
            }
        } else if (MCVR.MOD.keyRotateLeft.method_1436()) {
            this.dh.vrSettings.worldRotation += this.dh.vrSettings.worldRotationIncrement;
            this.dh.vrSettings.worldRotation %= 360.0f;
        } else if (MCVR.MOD.keyRotateRight.method_1436()) {
            this.dh.vrSettings.worldRotation -= this.dh.vrSettings.worldRotationIncrement;
            this.dh.vrSettings.worldRotation %= 360.0f;
        }
        Vector2fc axis = this.getInputAction(MCVR.MOD.keyFlickStick).getAxis2DUseTracked();
        if (axis.x() != 0.0f || axis.y() != 0.0f) {
            float rotation = (float)Math.toDegrees(Math.atan2(axis.x(), axis.y()));
            if (this.isFlickStick) {
                this.dh.vrSettings.worldRotation += this.flickStickRot - rotation;
            } else {
                this.isFlickStick = true;
                this.dh.vrSettings.worldRotation -= rotation;
            }
            this.dh.vrSettings.worldRotation %= 360.0f;
            this.flickStickRot = rotation;
        } else {
            this.flickStickRot = 0.0f;
            this.isFlickStick = false;
        }
        this.seatedRot = this.dh.vrSettings.worldRotation;
        if (MCVR.MOD.keyHotbarNext.method_1436()) {
            this.changeHotbar(-1);
            this.triggerBindingHapticPulse(MCVR.MOD.keyHotbarNext, 250);
        }
        if (MCVR.MOD.keyHotbarPrev.method_1436()) {
            this.changeHotbar(1);
            this.triggerBindingHapticPulse(MCVR.MOD.keyHotbarPrev, 250);
        }
        if (MCVR.MOD.keyQuickTorch.method_1436() && this.mc.field_1724 != null && this.mc.field_1755 == null) {
            for (int slot = 0; slot < 9; ++slot) {
                class_1747 item;
                class_1799 itemstack = this.mc.field_1724.method_31548().method_5438(slot);
                class_1792 class_17922 = itemstack.method_7909();
                if (!(class_17922 instanceof class_1747) || !((item = (class_1747)class_17922).method_7711() instanceof class_2527)) continue;
                this.quickTorchPreviousSlot = this.mc.field_1724.method_31548().method_67532();
                this.mc.field_1724.method_31548().method_61496(slot);
                this.mc.method_1583();
                this.mc.field_1724.method_31548().method_61496(this.quickTorchPreviousSlot);
                this.quickTorchPreviousSlot = -1;
                break;
            }
        }
        if (gui && !sleeping && this.mc.field_1690.field_1894.method_1434() && !(this.mc.field_1755 instanceof class_445) && this.mc.field_1724 != null) {
            this.mc.field_1724.method_7346();
        }
        if (this.mc.field_1755 instanceof class_465 && this.mc.field_1690.field_1822.method_1436() && this.mc.field_1724 != null) {
            this.mc.field_1724.method_7346();
        }
        if (this.mc.field_1755 instanceof class_408 && this.mc.field_1690.field_1890.method_1436()) {
            this.mc.method_1507(null);
        }
        if (MCVR.MOD.keySwapMirrorView.method_1436()) {
            if (this.dh.vrSettings.displayMirrorMode == VRSettings.MirrorMode.THIRD_PERSON) {
                this.dh.vrSettings.displayMirrorMode = VRSettings.MirrorMode.FIRST_PERSON;
            } else if (this.dh.vrSettings.displayMirrorMode == VRSettings.MirrorMode.FIRST_PERSON) {
                this.dh.vrSettings.displayMirrorMode = VRSettings.MirrorMode.THIRD_PERSON;
            }
            this.dh.vrRenderer.reinitFrameBuffersMaybe("Mirror Setting Changed");
        }
        if (!(!MCVR.MOD.keyMoveThirdPersonCam.method_1436() || this.dh.kiosk || this.dh.vrSettings.seated || this.dh.vrSettings.displayMirrorMode != VRSettings.MirrorMode.MIXED_REALITY && this.dh.vrSettings.displayMirrorMode != VRSettings.MirrorMode.THIRD_PERSON || (controller2 = this.findActiveBindingControllerType(MCVR.MOD.keyMoveThirdPersonCam)) == null)) {
            VRHotkeys.startMovingThirdPersonCam(controller2.ordinal(), VRHotkeys.Triggerer.BINDING);
        }
        if (VRHotkeys.isMovingThirdPersonCam() && ((trigger = VRHotkeys.getMovingThirdPersonCamTriggerer()) == VRHotkeys.Triggerer.MENUBUTTON && MCVR.MOD.keyMenuButton.method_1436() || trigger == VRHotkeys.Triggerer.BINDING && !MCVR.MOD.keyMoveThirdPersonCam.method_1434())) {
            VRHotkeys.stopMovingThirdPersonCam();
            this.dh.vrSettings.saveOptions();
        }
        if (MCVR.MOD.keyToggleKeyboard.method_1436()) {
            KeyboardHandler.setOverlayShowing(!KeyboardHandler.SHOWING);
        }
        if (KeyboardHandler.SHOWING && this.mc.field_1755 == null && MCVR.MOD.keyMenuButton.method_1436()) {
            KeyboardHandler.hideOverlay(CloseKeyboardContext.FORCE);
        }
        if (MCVR.MOD.keyRadialMenu.method_1436() && !gui && (controller = this.findActiveBindingControllerType(MCVR.MOD.keyRadialMenu)) != null) {
            RadialHandler.setOverlayShowing(!RadialHandler.isShowing(), controller);
        }
        if (RadialHandler.isShowing() && MCVR.MOD.keyMenuButton.method_1436()) {
            RadialHandler.setOverlayShowing(false, null);
        }
        if (MCVR.MOD.keyMenuButton.method_1436()) {
            if (!gui) {
                if (!this.dh.kiosk) {
                    this.mc.method_20539(false);
                }
            } else {
                InputSimulator.pressKey(256);
                InputSimulator.releaseKey(256);
            }
            KeyboardHandler.hideOverlay(CloseKeyboardContext.FORCE);
        }
        if (MCVR.MOD.keyTogglePlayerList.method_1436()) {
            ((GuiExtension)this.mc.field_1705).vivecraft$setShowPlayerList(!((GuiExtension)this.mc.field_1705).vivecraft$getShowPlayerList());
        }
        boolean toggleCam = MCVR.MOD.keyToggleHandheldCam.method_1436();
        boolean quickCam = MCVR.MOD.keyQuickHandheldCam.method_1436();
        if (this.mc.field_1724 != null && (toggleCam || quickCam)) {
            if (toggleCam || !this.dh.cameraTracker.isVisible()) {
                this.dh.cameraTracker.toggleVisibility();
            }
            if (this.dh.cameraTracker.isVisible()) {
                ControllerType hand = this.findActiveBindingControllerType(toggleCam ? MCVR.MOD.keyToggleHandheldCam : MCVR.MOD.keyQuickHandheldCam);
                if (hand == null) {
                    hand = ControllerType.RIGHT;
                }
                VRData.VRDevicePose handPose = this.dh.vrPlayer.vrdata_world_pre.getController(hand.ordinal());
                this.dh.cameraTracker.setPosition(handPose.getPosition());
                this.dh.cameraTracker.setRotation((Matrix4fc)handPose.getMatrix());
                if (quickCam) {
                    this.dh.cameraTracker.startMoving(hand.ordinal(), true);
                }
            }
        }
        if (!MCVR.MOD.keyQuickHandheldCam.method_1434() && this.dh.cameraTracker.isMoving() && this.dh.cameraTracker.isQuickMode() && this.mc.field_1724 != null) {
            this.dh.cameraTracker.stopMoving();
            this.dh.grabScreenShot = true;
        }
        if (MCVR.MOD.keyToggleWalkUpBlocks.method_1436()) {
            this.dh.vrSettings.walkUpBlocks = !this.dh.vrSettings.walkUpBlocks;
            ClientUtils.addChatMessage((class_2561)class_2561.method_43469((String)"vivecraft.messages.walkupblocks", (Object[])new Object[]{class_2561.method_43471((String)(this.dh.vrSettings.walkUpBlocks ? "options.on" : "options.off"))}));
        }
        this.isMovement = false;
        if (this.mc.field_1724 != null) {
            boolean climbing = !this.mc.field_1724.method_5799() && this.dh.climbTracker.isClimbeyClimb() && this.dh.climbTracker.isGrabbingLadder();
            float forward = 0.0f;
            if (!(this.dh.vrSettings.seated || this.mc.field_1755 != null || KeyboardHandler.SHOWING || climbing)) {
                Vector2fc moveStrafe = this.getInputAction(VivecraftVRMod.INSTANCE.keyFreeMoveStrafe).getAxis2DUseTracked();
                Vector2fc moveRotate = this.getInputAction(VivecraftVRMod.INSTANCE.keyFreeMoveRotate).getAxis2DUseTracked();
                this.movement.zero();
                if (moveStrafe.x() != 0.0f || moveStrafe.y() != 0.0f) {
                    this.isMovement = true;
                    this.movement.set(moveStrafe);
                } else if (moveRotate.y() != 0.0f) {
                    this.isMovement = true;
                    this.movement.y = moveRotate.y();
                    this.movement.x -= Math.abs(this.getInputAction(this.mc.field_1690.field_1849).getAxis1DUseTracked());
                    this.movement.x += Math.abs(this.getInputAction(this.mc.field_1690.field_1913).getAxis1DUseTracked());
                } else if (this.dh.vrSettings.analogMovement) {
                    this.movement.y = Math.abs(this.getInputAction(this.mc.field_1690.field_1894).getAxis1DUseTracked());
                    if (this.movement.y == 0.0f) {
                        this.movement.y = Math.abs(this.getInputAction(VivecraftVRMod.INSTANCE.keyTeleportFallback).getAxis1DUseTracked());
                    }
                    this.movement.y -= Math.abs(this.getInputAction(this.mc.field_1690.field_1881).getAxis1DUseTracked());
                    this.movement.x -= Math.abs(this.getInputAction(this.mc.field_1690.field_1849).getAxis1DUseTracked());
                    this.movement.x += Math.abs(this.getInputAction(this.mc.field_1690.field_1913).getAxis1DUseTracked());
                    float deadZone = 0.05f;
                    this.movement.y = MathUtils.applyDeadzone(this.movement.y, deadZone);
                    this.movement.x = MathUtils.applyDeadzone(this.movement.x, deadZone);
                    this.isMovement = this.movement.x != 0.0f || this.movement.y != 0.0f;
                }
                forward = this.movement.y;
                Vector2f digital = MathUtils.toDigital(this.movement, this.dh.vrSettings.digitalMovementDeadzone);
                if (!this.dh.vrSettings.analogMovement) {
                    this.movement = digital;
                }
                if (this.isMovement) {
                    this.getInputAction(this.mc.field_1690.field_1894).setPressed(digital.y > 0.0f);
                    this.getInputAction(this.mc.field_1690.field_1881).setPressed(digital.y < 0.0f);
                    this.getInputAction(this.mc.field_1690.field_1849).setPressed(digital.x > 0.0f);
                    this.getInputAction(this.mc.field_1690.field_1913).setPressed(digital.x < 0.0f);
                    if (this.dh.vrSettings.autoSprint && !this.mc.field_1724.method_20303()) {
                        if (forward >= this.dh.vrSettings.autoSprintThreshold) {
                            this.mc.field_1724.method_5728(true);
                            this.wasAutoSprinting = true;
                            this.movement.y = 1.0f;
                        } else if (this.movement.y > 0.0f && this.dh.vrSettings.analogMovement) {
                            this.movement.y /= this.dh.vrSettings.autoSprintThreshold;
                        }
                    }
                }
            }
            if (!this.isMovement && this.wasMovement) {
                this.getInputAction(this.mc.field_1690.field_1894).unpressBinding();
                this.getInputAction(this.mc.field_1690.field_1881).unpressBinding();
                this.getInputAction(this.mc.field_1690.field_1913).unpressBinding();
                this.getInputAction(this.mc.field_1690.field_1849).unpressBinding();
            }
            this.wasMovement = this.isMovement;
            if (this.wasAutoSprinting && forward < this.dh.vrSettings.autoSprintThreshold) {
                this.mc.field_1724.method_5728(false);
                this.wasAutoSprinting = false;
            }
        }
        GuiHandler.processBindingsGui();
        RadialHandler.processBindings();
        KeyboardHandler.processBindings();
        if (!this.mc.method_1493() && this.dh.interactTracker.isActive(this.mc.field_1724)) {
            this.dh.interactTracker.processBindings();
        }
    }

    public void populateInputActions() {
        Map<String, ActionParams> actionParams = this.getSpecialActionParams();
        for (class_304 keyMapping : Stream.concat(Arrays.stream(this.mc.field_1690.field_1839), MOD.getHiddenKeyBindings().stream()).toList()) {
            ActionParams params = actionParams.getOrDefault(keyMapping.method_1431(), ActionParams.DEFAULT);
            VRInputAction action = new VRInputAction(keyMapping, params.requirement(), params.type(), params.actionSetOverride());
            this.inputActions.put(action.name, action);
            this.inputActionsByKeyBinding.put(action.keyBinding.method_1431(), action);
        }
        this.getInputAction(MCVR.MOD.keyVRInteract).setPriority(5).setEnabled(false);
        this.getInputAction(MCVR.MOD.keyClimbeyGrab).setPriority(10).setEnabled(false);
        this.getInputAction(MCVR.MOD.keyClimbeyJump).setEnabled(false);
        this.getInputAction(GuiHandler.KEY_KEYBOARD_CLICK).setPriority(50);
        this.getInputAction(GuiHandler.KEY_KEYBOARD_SHIFT).setPriority(50);
    }

    public Map<String, ActionParams> getSpecialActionParams() {
        HashMap<String, ActionParams> map = new HashMap<String, ActionParams>();
        this.addActionParams(map, this.mc.field_1690.field_1894, "optional", "vector1", null);
        this.addActionParams(map, this.mc.field_1690.field_1881, "optional", "vector1", null);
        this.addActionParams(map, this.mc.field_1690.field_1913, "optional", "vector1", null);
        this.addActionParams(map, this.mc.field_1690.field_1849, "optional", "vector1", null);
        this.addActionParams(map, this.mc.field_1690.field_1822, "suggested", "boolean", VRInputActionSet.GLOBAL);
        this.addActionParams(map, this.mc.field_1690.field_1886, "suggested", "boolean", null);
        this.addActionParams(map, this.mc.field_1690.field_1904, "suggested", "boolean", null);
        this.addActionParams(map, this.mc.field_1690.field_1890, "optional", "boolean", VRInputActionSet.GLOBAL);
        this.addActionParams(map, MCVR.MOD.keyHotbarScroll, "optional", "vector2", null);
        this.addActionParams(map, MCVR.MOD.keyHotbarSwipeX, "optional", "vector2", null);
        this.addActionParams(map, MCVR.MOD.keyHotbarSwipeY, "optional", "vector2", null);
        this.addActionParams(map, MCVR.MOD.keyMenuButton, "suggested", "boolean", VRInputActionSet.GLOBAL);
        this.addActionParams(map, MCVR.MOD.keyTeleportFallback, "suggested", "vector1", null);
        this.addActionParams(map, MCVR.MOD.keyFreeMoveRotate, "optional", "vector2", null);
        this.addActionParams(map, MCVR.MOD.keyFreeMoveStrafe, "optional", "vector2", null);
        this.addActionParams(map, MCVR.MOD.keyRotateLeft, "optional", "vector1", null);
        this.addActionParams(map, MCVR.MOD.keyRotateRight, "optional", "vector1", null);
        this.addActionParams(map, MCVR.MOD.keyRotateAxis, "optional", "vector2", null);
        this.addActionParams(map, MCVR.MOD.keyFlickStick, "optional", "vector2", null);
        this.addActionParams(map, MCVR.MOD.keyRadialMenu, "suggested", "boolean", null);
        this.addActionParams(map, MCVR.MOD.keySwapMirrorView, "optional", "boolean", VRInputActionSet.GLOBAL);
        this.addActionParams(map, MCVR.MOD.keyToggleKeyboard, "optional", "boolean", VRInputActionSet.GLOBAL);
        this.addActionParams(map, MCVR.MOD.keyMoveThirdPersonCam, "optional", "boolean", VRInputActionSet.GLOBAL);
        this.addActionParams(map, MCVR.MOD.keyToggleHandheldCam, "optional", "boolean", VRInputActionSet.GLOBAL);
        this.addActionParams(map, MCVR.MOD.keyQuickHandheldCam, "optional", "boolean", VRInputActionSet.GLOBAL);
        this.addActionParams(map, MCVR.MOD.keyTrackpadTouch, "optional", "boolean", VRInputActionSet.TECHNICAL);
        this.addActionParams(map, MCVR.MOD.keyVRInteract, "suggested", "boolean", VRInputActionSet.CONTEXTUAL);
        this.addActionParams(map, MCVR.MOD.keyClimbeyGrab, "suggested", "boolean", null);
        this.addActionParams(map, MCVR.MOD.keyClimbeyJump, "suggested", "boolean", null);
        this.addActionParams(map, GuiHandler.KEY_LEFT_CLICK, "suggested", "boolean", null);
        this.addActionParams(map, GuiHandler.KEY_SCROLL_AXIS, "optional", "vector2", null);
        this.addActionParams(map, GuiHandler.KEY_RIGHT_CLICK, "suggested", "boolean", null);
        this.addActionParams(map, GuiHandler.KEY_SHIFT, "suggested", "boolean", null);
        this.addActionParams(map, GuiHandler.KEY_KEYBOARD_CLICK, "suggested", "boolean", null);
        this.addActionParams(map, GuiHandler.KEY_KEYBOARD_SHIFT, "suggested", "boolean", null);
        File file = new File("customactionsets.txt");
        if (file.exists()) {
            VRSettings.LOGGER.info("Vivecraft: Loading custom action set definitions...");
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
                String line;
                while ((line = bufferedReader.readLine()) != null) {
                    VRInputActionSet actionSet;
                    String[] tokens = line.split(":", 2);
                    if (tokens.length < 2) {
                        VRSettings.LOGGER.warn("Vivecraft: Invalid tokens: {}", (Object)line);
                        continue;
                    }
                    class_304 keyMapping = this.findKeyBinding(tokens[0]);
                    if (keyMapping == null) {
                        VRSettings.LOGGER.warn("Vivecraft: Unknown key binding: {}", (Object)tokens[0]);
                        continue;
                    }
                    if (MOD.getAllKeyBindings().contains(keyMapping)) {
                        VRSettings.LOGGER.warn("Vivecraft: NO! Don't touch Vivecraft bindings!: {}", (Object)keyMapping.method_1431());
                        continue;
                    }
                    switch (tokens[1].toLowerCase()) {
                        case "ingame": {
                            VRInputActionSet vRInputActionSet = VRInputActionSet.INGAME;
                            break;
                        }
                        case "gui": {
                            VRInputActionSet vRInputActionSet = VRInputActionSet.GUI;
                            break;
                        }
                        case "global": {
                            VRInputActionSet vRInputActionSet = VRInputActionSet.GLOBAL;
                            break;
                        }
                        default: {
                            VRInputActionSet vRInputActionSet = actionSet = null;
                        }
                    }
                    if (actionSet == null) {
                        VRSettings.LOGGER.warn("Vivecraft: Unknown action set: {}", (Object)tokens[1]);
                        continue;
                    }
                    this.addActionParams(map, keyMapping, "optional", "boolean", actionSet);
                }
            }
            catch (IOException e) {
                VRSettings.LOGGER.error("Vivecraft: Failed to read customactionsets.txt: ", (Throwable)e);
            }
        }
        return map;
    }

    private void addActionParams(Map<String, ActionParams> map, class_304 keyMapping, String requirement, String type, VRInputActionSet actionSetOverride) {
        ActionParams actionparams = new ActionParams(requirement, type, actionSetOverride);
        map.put(keyMapping.method_1431(), actionparams);
    }

    public boolean handleKeyboardInputs(int key, int scanCode, int action, int modifiers) {
        return false;
    }

    public void calibrateFBT(float headsetYaw) {
        int t;
        Vector3f tempV = new Vector3f();
        float scale = AutoCalibration.getPlayerHeight() / 1.52f * 0.9375f;
        Vector3f posAvg = this.hmdPivotHistory.averagePosition(0.5);
        List<Triple<DeviceSource, Integer, Matrix4fc>> trackers = this.getTrackers();
        int startIndex = -1;
        int endIndex = trackers.size();
        if (!this.hasExtendedFBT() && trackers.size() >= 7) {
            startIndex = !this.hasFBT() ? 0 : 3;
            endIndex = 7;
        } else if (!this.hasFBT() && trackers.size() >= 3) {
            startIndex = 0;
            endIndex = 3;
        }
        if (startIndex >= 0) {
            this.usingUnlabeledTrackers = true;
            ArrayList<Integer> indices = new ArrayList<Integer>();
            for (int t2 = startIndex + 3; t2 < endIndex + 3; ++t2) {
                if (this.deviceSource[t2].isValid()) {
                    int finalT = t2;
                    trackers.removeIf(triple -> ((DeviceSource)triple.getLeft()).equals(this.deviceSource[finalT]));
                    continue;
                }
                indices.add(t2);
            }
            Iterator t2 = indices.iterator();
            while (t2.hasNext()) {
                int t3 = (Integer)t2.next();
                int closestIndex = -1;
                float closestDistance = Float.MAX_VALUE;
                for (int i = 0; i < trackers.size(); ++i) {
                    Triple<DeviceSource, Integer, Matrix4fc> tracker = trackers.get(i);
                    ((Matrix4fc)tracker.getRight()).getTranslation(tempV).sub(posAvg.x, 0.0f, posAvg.z).rotateY(headsetYaw).mul(scale);
                    float dist = tempV.distance(FBT_REFERENCE_POSITIONS[t3 - 3]);
                    if (!(dist < closestDistance)) continue;
                    closestDistance = dist;
                    closestIndex = i;
                }
                this.deviceSource[t3].set((DeviceSource)trackers.get(closestIndex).getLeft());
                this.controllerPose[t3].set((Matrix4fc)trackers.get(closestIndex).getRight());
                trackers.remove(closestIndex);
            }
        } else {
            this.usingUnlabeledTrackers = false;
        }
        for (t = 3; t < (this.hasExtendedFBT() ? 10 : 6); ++t) {
            Matrix4f rotationOffset = this.controllerPose[t].rotateLocalY(headsetYaw, new Matrix4f());
            rotationOffset.getUnnormalizedRotation(this.dh.vrSettings.fbtRotations[t - 3]).conjugate();
        }
        for (t = 3; t < (this.hasExtendedFBT() ? 10 : 6); ++t) {
            Vector3f offset = FBT_REFERENCE_POSITIONS[t - 3].mul(scale, new Vector3f()).sub((Vector3fc)this.controllerPose[t].getTranslation(tempV).sub(posAvg.x, 0.0f, posAvg.z).rotateY(headsetYaw));
            this.dh.vrSettings.fbtOffsets[t - 3].set((Vector3fc)offset);
        }
        if (this.hasFBT()) {
            this.dh.vrSettings.fbtCalibrated = true;
        }
        if (this.hasExtendedFBT()) {
            this.dh.vrSettings.fbtExtendedCalibrated = true;
        }
    }

    public void resetFBT() {
        for (int i = 3; i < 10; ++i) {
            this.deviceSource[i].reset();
        }
    }

    public List<Triple<DeviceSource, Integer, Matrix4fc>> getTrackers() {
        int i;
        ArrayList<Triple<DeviceSource, Integer, Matrix4fc>> poses = new ArrayList<Triple<DeviceSource, Integer, Matrix4fc>>();
        Vector3f offset = new Vector3f();
        if (!this.dh.vrSettings.seated && this.dh.vrSettings.allowStandingOriginOffset && this.dh.vr.isHMDTracking()) {
            offset.set((Vector3fc)this.dh.vrSettings.originOffset);
        }
        for (i = 3; i < 10; ++i) {
            if (!this.deviceSource[i].isValid()) continue;
            poses.add((Triple<DeviceSource, Integer, Matrix4fc>)Triple.of((Object)this.deviceSource[i], (Object)i, (Object)MathUtils.addTranslation(new Matrix4f((Matrix4fc)this.controllerPose[i]), offset)));
        }
        if (this.oscTrackers.hasTrackers()) {
            for (i = 0; i < this.oscTrackers.trackers.length; ++i) {
                OSCTracker tracker = this.oscTrackers.trackers[i];
                int finalI = i;
                if (!tracker.isTracking() || !poses.stream().noneMatch(t -> ((DeviceSource)t.getLeft()).is(DeviceSource.Source.OSC, finalI))) continue;
                poses.add((Triple<DeviceSource, Integer, Matrix4fc>)Triple.of((Object)new DeviceSource(DeviceSource.Source.OSC, i), (Object)-1, (Object)MathUtils.addTranslation(new Matrix4f((Matrix4fc)tracker.pose), offset)));
            }
        }
        return poses;
    }

    public abstract String getName();

    public abstract void processInputs();

    protected abstract ControllerType findActiveBindingControllerType(class_304 var1);

    public abstract void poll(long var1);

    public abstract Vector2fc getPlayAreaSize();

    public abstract void refreshControllerTransforms();

    public abstract Matrix4fc getControllerComponentTransform(int var1, String var2);

    public boolean hasCameraTracker() {
        return this.deviceSource[2].isValid();
    }

    public boolean hasFBT() {
        return this.deviceSource[3].isValid() && this.deviceSource[5].isValid() && this.deviceSource[4].isValid();
    }

    public boolean hasExtendedFBT() {
        return this.hasFBT() && this.deviceSource[7].isValid() && this.deviceSource[6].isValid() && this.deviceSource[9].isValid() && this.deviceSource[8].isValid();
    }

    public abstract List<Long> getOrigins(VRInputAction var1);

    public abstract String getOriginName(long var1);

    public abstract VRRenderer createVRRenderer();

    public abstract boolean isActive();

    public boolean capFPS() {
        return false;
    }

    public abstract float getIPD();

    public abstract String getRuntimeName();

    static {
        FBT_REFERENCE_POSITIONS = new Vector3fc[]{new Vector3f(0.0f, 0.875f, 0.0f), new Vector3f(0.125f, 0.0f, 0.0f), new Vector3f(-0.125f, 0.0f, 0.0f), new Vector3f(0.625f, 1.375f, 0.0f), new Vector3f(-0.625f, 1.375f, 0.0f), new Vector3f(0.125f, 0.375f, -0.05f), new Vector3f(-0.125f, 0.375f, -0.05f)};
    }
}

