/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gameplay.screenhandlers;

import java.util.Iterator;
import net.minecraft.class_10209;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_276;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_408;
import net.minecraft.class_437;
import net.minecraft.class_445;
import net.minecraft.class_465;
import net.minecraft.class_473;
import net.minecraft.class_7265;
import net.minecraft.class_7743;
import net.minecraft.class_7920;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.api.client.data.CloseKeyboardContext;
import org.vivecraft.api.client.data.RenderPass;
import org.vivecraft.client.VivecraftVRMod;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.MethodHolder;
import org.vivecraft.client_vr.VRData;
import org.vivecraft.client_vr.VRState;
import org.vivecraft.client_vr.extensions.WindowExtension;
import org.vivecraft.client_vr.gameplay.VRPlayer;
import org.vivecraft.client_vr.gameplay.screenhandlers.KeyboardHandler;
import org.vivecraft.client_vr.gameplay.screenhandlers.RadialHandler;
import org.vivecraft.client_vr.provider.ControllerType;
import org.vivecraft.client_vr.provider.HandedKeyBinding;
import org.vivecraft.client_vr.provider.InputSimulator;
import org.vivecraft.client_vr.provider.MCVR;
import org.vivecraft.client_vr.render.helpers.RenderHelper;
import org.vivecraft.client_vr.settings.AutoCalibration;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.common.utils.MathUtils;

public class GuiHandler {
    public static final class_310 MC = class_310.method_1551();
    public static final ClientDataHolderVR DH = ClientDataHolderVR.getInstance();
    private static double CONTROLLER_MOUSE_X = -1.0;
    private static double CONTROLLER_MOUSE_Y = -1.0;
    private static boolean CONTROLLER_MOUSE_VALID;
    private static boolean LAST_PRESSED_LEFT_CLICK;
    private static boolean LAST_PRESSED_RIGHT_CLICK;
    private static boolean LAST_PRESSED_MIDDLE_CLICK;
    private static boolean LAST_PRESSED_SHIFT;
    private static boolean LAST_PRESSED_CRTL;
    private static boolean LAST_PRESSED_ALT;
    public static final class_304 KEY_LEFT_CLICK;
    public static final class_304 KEY_RIGHT_CLICK;
    public static final class_304 KEY_MIDDLE_CLICK;
    public static final class_304 KEY_SHIFT;
    public static final class_304 KEY_CTRL;
    public static final class_304 KEY_ALT;
    public static final class_304 KEY_SCROLL_UP;
    public static final class_304 KEY_SCROLL_DOWN;
    public static final class_304 KEY_SCROLL_AXIS;
    public static final HandedKeyBinding KEY_KEYBOARD_CLICK;
    public static final HandedKeyBinding KEY_KEYBOARD_SHIFT;
    public static class_276 GUI_FRAMEBUFFER;
    public static boolean GUI_APPEAR_OVER_BLOCK_ACTIVE;
    public static float GUI_SCALE;
    public static float GUI_SCALE_APPLIED;
    public static Vector3f GUI_POS_ROOM;
    public static Matrix4f GUI_ROTATION_ROOM;
    public static Vector3f GUI_RENDER_POS_ROOM;
    public static Vector3f GUI_OFFSET_LOCAL;
    public static Matrix4f GUI_RENDER_ROTATION_ROOM;
    public static Matrix4f GUI_ROTATION_PLAYER_MODEL;
    public static class_243 GUI_POS_PLAYER_MODEL;
    public static boolean HUD_POPUP;
    public static int GUI_WIDTH;
    public static int GUI_HEIGHT;
    public static int GUI_SCALE_FACTOR_MAX;
    public static int GUI_SCALE_FACTOR;
    public static int SCALED_WIDTH;
    public static int SCALED_HEIGHT;
    public static int SCALED_WIDTH_MAX;
    public static int SCALED_HEIGHT_MAX;
    private static int PREVIOUS_GUI_SCALE;

    public static int calculateScale(int scaleIn, boolean forceUnicode, int framebufferWidth, int framebufferHeight) {
        int maxScale;
        int scale = 1;
        for (maxScale = 1; maxScale < framebufferWidth && maxScale < framebufferHeight && framebufferWidth / (maxScale + 1) >= 320 && framebufferHeight / (maxScale + 1) >= 240; ++maxScale) {
            if (scale >= scaleIn && scaleIn != 0) continue;
            ++scale;
        }
        if (forceUnicode) {
            if (scale % 2 != 0) {
                ++scale;
            }
            if (maxScale % 2 != 0) {
                ++maxScale;
            }
        }
        GUI_SCALE_FACTOR_MAX = maxScale;
        SCALED_WIDTH = class_3532.method_15386((float)((float)framebufferWidth / (float)scale));
        SCALED_WIDTH_MAX = class_3532.method_15386((float)((float)framebufferWidth / (float)maxScale));
        SCALED_HEIGHT = class_3532.method_15386((float)((float)framebufferHeight / (float)scale));
        SCALED_HEIGHT_MAX = class_3532.method_15386((float)((float)framebufferHeight / (float)maxScale));
        return scale;
    }

    public static boolean updateResolution() {
        int newGuiScale;
        int oldWidth = GUI_WIDTH;
        int oldHeight = GUI_HEIGHT;
        int oldGuiScale = GUI_SCALE_FACTOR;
        GUI_WIDTH = GuiHandler.DH.vrSettings.doubleGUIResolution ? 2560 : 1280;
        GUI_HEIGHT = GuiHandler.DH.vrSettings.doubleGUIResolution ? 1440 : 720;
        int n = newGuiScale = GuiHandler.DH.vrSettings.doubleGUIResolution ? GuiHandler.DH.vrSettings.guiScale : (int)Math.ceil((float)GuiHandler.DH.vrSettings.guiScale * 0.5f);
        if (oldWidth != GUI_WIDTH || PREVIOUS_GUI_SCALE != newGuiScale) {
            GUI_SCALE_FACTOR = GuiHandler.calculateScale(newGuiScale, false, GUI_WIDTH, GUI_HEIGHT);
            PREVIOUS_GUI_SCALE = newGuiScale;
        }
        if (oldWidth != GUI_WIDTH) {
            InputSimulator.setMousePos(GuiHandler.MC.field_1729.method_1603() * (double)((WindowExtension)MC.method_22683()).vivecraft$getActualScreenWidth() / (double)oldWidth, GuiHandler.MC.field_1729.method_1604() * (double)((WindowExtension)MC.method_22683()).vivecraft$getActualScreenHeight() / (double)oldHeight);
            CONTROLLER_MOUSE_X *= (double)GUI_WIDTH / (double)oldWidth;
            CONTROLLER_MOUSE_Y *= (double)GUI_HEIGHT / (double)oldHeight;
            return true;
        }
        return oldGuiScale != GUI_SCALE_FACTOR;
    }

    public static void processGui() {
        if (GUI_ROTATION_ROOM == null) {
            return;
        }
        if (GuiHandler.DH.vrSettings.seated) {
            return;
        }
        if (!MCVR.get().isControllerTracking(0)) {
            return;
        }
        if (GuiHandler.MC.field_1755 == null && GuiHandler.MC.field_1729.method_1613()) {
            return;
        }
        Vector2f tex = GuiHandler.getTexCoordsForCursor(GUI_POS_ROOM, GUI_ROTATION_ROOM, GUI_SCALE, GuiHandler.DH.vrPlayer.vrdata_room_pre.getController(0));
        float u = tex.x;
        float v = tex.y;
        if (u < 0.0f || v < 0.0f || u > 1.0f || v > 1.0f) {
            CONTROLLER_MOUSE_X = -1.0;
            CONTROLLER_MOUSE_Y = -1.0;
            CONTROLLER_MOUSE_VALID = false;
        } else if (!CONTROLLER_MOUSE_VALID) {
            CONTROLLER_MOUSE_X = (int)(u * (float)MC.method_22683().method_4489());
            CONTROLLER_MOUSE_Y = (int)(v * (float)MC.method_22683().method_4506());
            CONTROLLER_MOUSE_VALID = true;
        } else {
            float newX = (int)(u * (float)MC.method_22683().method_4489());
            float newY = (int)(v * (float)MC.method_22683().method_4506());
            CONTROLLER_MOUSE_X = CONTROLLER_MOUSE_X * (double)0.7f + (double)(newX * 0.3f);
            CONTROLLER_MOUSE_Y = CONTROLLER_MOUSE_Y * (double)0.7f + (double)(newY * 0.3f);
            CONTROLLER_MOUSE_VALID = true;
        }
        if (CONTROLLER_MOUSE_VALID) {
            InputSimulator.setMousePos(CONTROLLER_MOUSE_X * ((double)((WindowExtension)MC.method_22683()).vivecraft$getActualScreenWidth() / (double)MC.method_22683().method_4480()), CONTROLLER_MOUSE_Y * ((double)((WindowExtension)MC.method_22683()).vivecraft$getActualScreenHeight() / (double)MC.method_22683().method_4507()));
        }
    }

    public static Vector2f getTexCoordsForCursor(Vector3f guiPos_room, Matrix4f guiRotation_room, float guiScale, VRData.VRDevicePose controller) {
        Vector3f guiPos;
        Vector3f guiTopLeft;
        float intersectDist;
        Vector3f controllerPos = controller.getPositionF();
        Vector3f controllerDir = controller.getDirection();
        Vector3f guiNormal = guiRotation_room.transformDirection(MathUtils.FORWARD, new Vector3f());
        Vector3f guiRight = guiRotation_room.transformDirection(MathUtils.LEFT, new Vector3f());
        Vector3f guiUp = guiRotation_room.transformDirection(MathUtils.UP, new Vector3f());
        float guiDotController = guiNormal.dot((Vector3fc)controllerDir);
        if (Math.abs(guiDotController) > 1.0E-5f && (intersectDist = -guiNormal.dot((Vector3fc)controllerPos.sub((Vector3fc)(guiTopLeft = (guiPos = new Vector3f((Vector3fc)guiPos_room)).sub((Vector3fc)guiUp.mul(0.5f, new Vector3f())).sub((Vector3fc)guiRight.mul(0.5f, new Vector3f()))), new Vector3f())) / guiDotController) > 0.0f) {
            Vector3f pointOnPlane = controllerPos.add((Vector3fc)controllerDir.mul(intersectDist), new Vector3f());
            pointOnPlane.sub((Vector3fc)guiTopLeft);
            float u = pointOnPlane.dot((Vector3fc)guiRight);
            float v = pointOnPlane.dot((Vector3fc)guiUp);
            float aspect = (float)MC.method_22683().method_4502() / (float)MC.method_22683().method_4486();
            u = (u - 0.5f) / 1.5f / guiScale + 0.5f;
            v = (v - 0.5f) / aspect / 1.5f / guiScale + 0.5f;
            v = 1.0f - v;
            return new Vector2f(u, v);
        }
        return new Vector2f(-1.0f, -1.0f);
    }

    public static void processBindingsGui() {
        boolean mouseValid;
        boolean bl = mouseValid = CONTROLLER_MOUSE_X >= 0.0 && CONTROLLER_MOUSE_X < (double)MC.method_22683().method_4480() && CONTROLLER_MOUSE_Y >= 0.0 && CONTROLLER_MOUSE_Y < (double)MC.method_22683().method_4480();
        if (KEY_LEFT_CLICK.method_1436() && GuiHandler.MC.field_1755 != null && mouseValid) {
            InputSimulator.pressMouse(0);
            LAST_PRESSED_LEFT_CLICK = true;
        }
        if (!KEY_LEFT_CLICK.method_1434() && LAST_PRESSED_LEFT_CLICK) {
            InputSimulator.releaseMouse(0);
            LAST_PRESSED_LEFT_CLICK = false;
        }
        if (KEY_RIGHT_CLICK.method_1436() && GuiHandler.MC.field_1755 != null && mouseValid) {
            InputSimulator.pressMouse(1);
            LAST_PRESSED_RIGHT_CLICK = true;
        }
        if (!KEY_RIGHT_CLICK.method_1434() && LAST_PRESSED_RIGHT_CLICK) {
            InputSimulator.releaseMouse(1);
            LAST_PRESSED_RIGHT_CLICK = false;
        }
        if (KEY_MIDDLE_CLICK.method_1436() && GuiHandler.MC.field_1755 != null && mouseValid) {
            InputSimulator.pressMouse(2);
            LAST_PRESSED_MIDDLE_CLICK = true;
        }
        if (!KEY_MIDDLE_CLICK.method_1434() && LAST_PRESSED_MIDDLE_CLICK) {
            InputSimulator.releaseMouse(2);
            LAST_PRESSED_MIDDLE_CLICK = false;
        }
        if (KEY_SHIFT.method_1436() && GuiHandler.MC.field_1755 != null) {
            InputSimulator.pressKey(340);
            LAST_PRESSED_SHIFT = true;
        }
        if (!KEY_SHIFT.method_1434() && LAST_PRESSED_SHIFT) {
            InputSimulator.releaseKey(340);
            LAST_PRESSED_SHIFT = false;
        }
        if (KEY_CTRL.method_1436() && GuiHandler.MC.field_1755 != null) {
            InputSimulator.pressKey(341);
            LAST_PRESSED_CRTL = true;
        }
        if (!KEY_CTRL.method_1434() && LAST_PRESSED_CRTL) {
            InputSimulator.releaseKey(341);
            LAST_PRESSED_CRTL = false;
        }
        if (KEY_ALT.method_1436() && GuiHandler.MC.field_1755 != null) {
            InputSimulator.pressKey(342);
            LAST_PRESSED_ALT = true;
        }
        if (!KEY_ALT.method_1434() && LAST_PRESSED_ALT) {
            InputSimulator.releaseKey(342);
            LAST_PRESSED_ALT = false;
        }
        if (KEY_SCROLL_UP.method_1436() && GuiHandler.MC.field_1755 != null) {
            InputSimulator.scrollMouse(0.0, 4.0);
        }
        if (KEY_SCROLL_DOWN.method_1436() && GuiHandler.MC.field_1755 != null) {
            InputSimulator.scrollMouse(0.0, -4.0);
        }
    }

    public static void onScreenChanged(class_437 previousGuiScreen, class_437 newScreen, boolean unpressKeys) {
        GuiHandler.onScreenChanged(previousGuiScreen, newScreen, unpressKeys, false);
    }

    public static void onScreenChanged(class_437 previousGuiScreen, class_437 newScreen, boolean unpressKeys, boolean infrontOfHand) {
        if (!VRState.VR_RUNNING) {
            return;
        }
        if (unpressKeys) {
            GuiHandler.DH.vr.ignorePressesNextFrame = true;
        }
        if (newScreen == null) {
            GUI_POS_ROOM = null;
            GUI_ROTATION_ROOM = null;
            GUI_SCALE = 1.0f;
            if (KeyboardHandler.KEYBOARD_FOR_GUI) {
                KeyboardHandler.hideOverlay(CloseKeyboardContext.ACTION_COMPLETE);
            }
        } else {
            RadialHandler.setOverlayShowing(false, null);
        }
        if (GuiHandler.MC.field_1687 == null || newScreen instanceof class_445) {
            GuiHandler.DH.vrSettings.worldRotationCached = GuiHandler.DH.vrSettings.worldRotation;
            GuiHandler.DH.vrSettings.worldRotation = 0.0f;
        } else if (GuiHandler.DH.vrSettings.worldRotationCached != 0.0f) {
            GuiHandler.DH.vrSettings.worldRotation = GuiHandler.DH.vrSettings.worldRotationCached;
            GuiHandler.DH.vrSettings.worldRotationCached = 0.0f;
        }
        boolean staticScreen = MethodHolder.willBeInMenuRoom(newScreen);
        if (staticScreen &= !GuiHandler.DH.vrSettings.seated && !GuiHandler.DH.vrSettings.menuAlwaysFollowFace) {
            GUI_SCALE = 2.0f;
            Vector2fc playArea = MCVR.get().getPlayAreaSize();
            GUI_POS_ROOM = new Vector3f(0.02f, 1.3f, -Math.max(playArea != null ? playArea.y() * 0.5f : 0.0f, 1.5f));
            GUI_ROTATION_ROOM = new Matrix4f();
            return;
        }
        if (previousGuiScreen == null && newScreen != null || newScreen instanceof class_408 || newScreen instanceof class_473 || newScreen instanceof class_7743) {
            VRData.VRDevicePose facingDevice;
            boolean isBlockScreen = newScreen instanceof class_465 && GuiHandler.MC.field_1765 != null && GuiHandler.MC.field_1765.method_17783() == class_239.class_240.field_1332;
            boolean isEntityScreen = newScreen instanceof class_465 && GuiHandler.MC.field_1765 instanceof class_3966 && ((class_3966)GuiHandler.MC.field_1765).method_17782() instanceof class_7265;
            VRData.VRDevicePose vRDevicePose = facingDevice = infrontOfHand ? GuiHandler.DH.vrPlayer.vrdata_room_pre.getController(0) : GuiHandler.DH.vrPlayer.vrdata_room_pre.hmd;
            if (GUI_APPEAR_OVER_BLOCK_ACTIVE && (isBlockScreen || isEntityScreen) && GuiHandler.DH.vrSettings.guiAppearOverBlock) {
                class_243 sourcePos;
                if (isEntityScreen) {
                    class_3966 entityHitResult = (class_3966)GuiHandler.MC.field_1765;
                    sourcePos = entityHitResult.method_17782().method_73189();
                } else {
                    class_3965 blockHitResult = (class_3965)GuiHandler.MC.field_1765;
                    sourcePos = new class_243((double)blockHitResult.method_17777().method_10263() + 0.5, (double)blockHitResult.method_17777().method_10264(), (double)blockHitResult.method_17777().method_10260() + 0.5);
                }
                Vector3f roomPos = VRPlayer.worldToRoomPos(sourcePos, GuiHandler.DH.vrPlayer.vrdata_world_pre);
                Vector3f hmdPos = GuiHandler.DH.vrPlayer.vrdata_room_pre.hmd.getPositionF();
                float distance = roomPos.sub((Vector3fc)hmdPos).length();
                GUI_SCALE = (float)Math.sqrt(distance);
                class_243 sourcePosWorld = new class_243(sourcePos.field_1352, sourcePos.field_1351 + (double)1.1f + (double)(GUI_SCALE * 0.25f), sourcePos.field_1350);
                GUI_POS_ROOM = VRPlayer.worldToRoomPos(sourcePosWorld, GuiHandler.DH.vrPlayer.vrdata_world_pre);
            } else {
                Vector3f offset = new Vector3f(0.0f, 0.0f, -2.0f);
                if (newScreen instanceof class_408) {
                    offset.set(0.0f, 0.5f, -2.0f);
                } else if (newScreen instanceof class_473 || newScreen instanceof class_7743) {
                    offset.set(0.0f, 0.25f, -2.0f);
                }
                Vector3f hmdPos = facingDevice.getPositionF();
                Vector3f look = facingDevice.getCustomVector((Vector3fc)offset);
                GUI_POS_ROOM = new Vector3f(look.x * 0.5f + hmdPos.x, look.y * 0.5f + hmdPos.y, look.z * 0.5f + hmdPos.z);
                if (GuiHandler.DH.vrSettings.physicalKeyboard && KeyboardHandler.SHOWING && GuiHandler.GUI_POS_ROOM.y < hmdPos.y + 0.2f) {
                    GUI_POS_ROOM.set(GuiHandler.GUI_POS_ROOM.x, hmdPos.y + 0.2f, GuiHandler.GUI_POS_ROOM.z);
                }
            }
            Vector3f hmdPos = facingDevice.getPositionF();
            Vector3f look = GUI_POS_ROOM.sub((Vector3fc)hmdPos, new Vector3f());
            float pitch = (float)Math.asin(look.y / look.length());
            float yaw = (float)Math.PI + (float)Math.atan2(look.x, look.z);
            GUI_ROTATION_ROOM = new Matrix4f().rotationY(yaw);
            GUI_ROTATION_ROOM.rotateX(pitch);
        }
        KeyboardHandler.orientOverlay(newScreen != null);
    }

    public static class_243 applyGUIModelView(RenderPass currentPass, Matrix4f poseMatrix) {
        class_10209.method_64146().method_15396("applyGUIModelView");
        if (GuiHandler.MC.field_1755 != null && GUI_POS_ROOM == null) {
            GuiHandler.onScreenChanged(null, GuiHandler.MC.field_1755, false);
        } else if (GuiHandler.MC.field_1755 == null && !GuiHandler.MC.field_1729.method_1613()) {
            if (GUI_POS_ROOM == null) {
                GuiHandler.onScreenChanged(null, new class_437((class_2561)class_2561.method_43473()){}, false, true);
            }
        } else if (GuiHandler.MC.field_1755 == null && GUI_POS_ROOM != null) {
            GuiHandler.onScreenChanged(null, null, false);
        }
        class_243 guipos = null;
        Matrix4f guirot = GUI_ROTATION_ROOM;
        Vector3f guilocal = new Vector3f();
        float scale = GUI_SCALE;
        if (GUI_POS_ROOM == null) {
            guirot = null;
            scale = 1.0f;
            if (!(GuiHandler.MC.field_1687 == null || GuiHandler.MC.field_1755 != null && GuiHandler.DH.vrSettings.floatInventory)) {
                int side = 1;
                if (GuiHandler.DH.vrSettings.reverseHands) {
                    side = -1;
                }
                if (GuiHandler.DH.vrSettings.seated || GuiHandler.DH.vrSettings.vrHudLockMode == VRSettings.HUDLock.HEAD) {
                    guirot = new Matrix4f().rotationY(GuiHandler.DH.vrPlayer.vrdata_world_render.rotation_radians);
                    class_243 position = GuiHandler.DH.vrPlayer.vrdata_world_render.hmd.getPosition();
                    Vector3f direction = GuiHandler.DH.vrPlayer.vrdata_world_render.hmd.getDirection();
                    if (GuiHandler.DH.vrSettings.seated && GuiHandler.DH.vrSettings.seatedHudAltMode) {
                        direction = GuiHandler.DH.vrPlayer.vrdata_world_render.getController(0).getDirection();
                        guirot = guirot.mul(GuiHandler.DH.vr.getAimRotation(0), guirot);
                    } else {
                        guirot = guirot.mul((Matrix4fc)GuiHandler.DH.vr.hmdRotation, guirot);
                    }
                    guipos = new class_243(position.field_1352 + (double)(direction.x * GuiHandler.DH.vrPlayer.vrdata_world_render.worldScale * GuiHandler.DH.vrSettings.hudDistance), position.field_1351 + (double)(direction.y * GuiHandler.DH.vrPlayer.vrdata_world_render.worldScale * GuiHandler.DH.vrSettings.hudDistance), position.field_1350 + (double)(direction.z * GuiHandler.DH.vrPlayer.vrdata_world_render.worldScale * GuiHandler.DH.vrSettings.hudDistance));
                    scale = GuiHandler.DH.vrSettings.hudScale;
                } else {
                    boolean modelArms;
                    boolean bl = modelArms = GUI_POS_PLAYER_MODEL != class_243.field_1353 && GuiHandler.DH.vrSettings.shouldRenderSelf && GuiHandler.DH.vrSettings.modelArmsMode == VRSettings.ModelArmsMode.COMPLETE;
                    if (modelArms) {
                        guirot = new Matrix4f().set3x3((Matrix4fc)GUI_ROTATION_PLAYER_MODEL);
                        guipos = GUI_POS_PLAYER_MODEL;
                    } else {
                        guirot = new Matrix4f().rotationY(GuiHandler.DH.vrPlayer.vrdata_world_render.rotation_radians);
                        guirot.mul(GuiHandler.DH.vr.getAimRotation(1));
                        guipos = RenderHelper.getControllerRenderPos(1);
                    }
                    HUD_POPUP = true;
                    if (GuiHandler.DH.vrSettings.vrHudLockMode == VRSettings.HUDLock.HAND) {
                        scale = 0.58823526f;
                        guirot.rotateX(-0.62831855f);
                        guirot.rotateY(0.31415927f * (float)side);
                        guilocal = new Vector3f(guilocal.x, 0.32f * GuiHandler.DH.vrPlayer.vrdata_world_render.worldScale, guilocal.z);
                    } else {
                        scale = 0.4f;
                        boolean slim = GuiHandler.MC.field_1724.method_52814().comp_1629() == class_7920.field_41122;
                        float xOffset = -0.136f;
                        float yOffset = slim ? 0.085f : 0.055f;
                        float yScaleOffset = slim ? 0.0825f : 0.1125f;
                        float armScale = 0.42f;
                        if (modelArms) {
                            armScale = GuiHandler.DH.vrSettings.playerModelArmsScale;
                            if (GuiHandler.DH.vrSettings.playerModelType == VRSettings.PlayerModelType.VANILLA) {
                                yOffset = 0.11f;
                                yScaleOffset = 0.0575f;
                            }
                        }
                        guilocal.set(xOffset * (float)side, yOffset + yScaleOffset * (1.0f - armScale), (0.12f + 0.02f * GuiHandler.DH.vrSettings.vrHudWristOffset) * armScale);
                        guilocal.mul(GuiHandler.DH.vrPlayer.vrdata_world_render.worldScale);
                        if (modelArms) {
                            float playerScale = AutoCalibration.getPlayerHeight() / 1.52f;
                            scale *= playerScale;
                            guilocal.mul(playerScale);
                        }
                        guirot.rotateZ(1.5707964f * (float)side);
                        guirot.rotateY(1.5707964f * (float)side);
                    }
                }
            }
        } else {
            guipos = VRPlayer.roomToWorldPos((Vector3fc)GUI_POS_ROOM, GuiHandler.DH.vrPlayer.vrdata_world_render);
            guirot = new Matrix4f().rotationY(GuiHandler.DH.vrPlayer.vrdata_world_render.rotation_radians).mul((Matrix4fc)guirot);
        }
        if ((GuiHandler.DH.vrSettings.seated || GuiHandler.DH.vrSettings.menuAlwaysFollowFace) && MethodHolder.isInMenuRoom()) {
            scale = 2.0f;
            Vector3f posAvg = new Vector3f();
            for (Vector3f sample : GuiHandler.DH.vr.hmdPosSamples) {
                posAvg.add((Vector3fc)sample);
            }
            posAvg.div((float)GuiHandler.DH.vr.hmdPosSamples.size());
            float yawAvg = 0.0f;
            Iterator sample = GuiHandler.DH.vr.hmdYawSamples.iterator();
            while (sample.hasNext()) {
                float sample2 = ((Float)sample.next()).floatValue();
                yawAvg += sample2;
            }
            yawAvg /= (float)GuiHandler.DH.vr.hmdYawSamples.size();
            yawAvg = (float)Math.PI / 180 * yawAvg;
            Vector3f dir = new Vector3f(-class_3532.method_15374((float)yawAvg), 0.0f, class_3532.method_15362((float)yawAvg));
            float dist = MethodHolder.isInMenuRoom() ? 2.5f * GuiHandler.DH.vrPlayer.vrdata_world_render.worldScale : GuiHandler.DH.vrSettings.hudDistance;
            posAvg.add(dir.x * dist, dir.y * dist, dir.z * dist);
            Matrix4f guiRotation = new Matrix4f().rotationY((float)Math.PI - yawAvg);
            guirot = guiRotation.rotateY(GuiHandler.DH.vrPlayer.vrdata_world_render.rotation_radians, new Matrix4f());
            guipos = VRPlayer.roomToWorldPos((Vector3fc)posAvg, GuiHandler.DH.vrPlayer.vrdata_world_render);
            GUI_ROTATION_ROOM = guiRotation;
            GUI_SCALE = 2.0f;
            GUI_POS_ROOM = posAvg;
        }
        if (guipos == null) {
            VRSettings.LOGGER.error("Vivecraft: guipos was null, how did that happen. vrRunning: {}: ", (Object)VRState.VR_RUNNING, (Object)new RuntimeException());
            GUI_POS_ROOM = new Vector3f();
            guipos = VRPlayer.roomToWorldPos((Vector3fc)GUI_POS_ROOM, GuiHandler.DH.vrPlayer.vrdata_world_render);
            GUI_ROTATION_ROOM = new Matrix4f();
            guirot = new Matrix4f();
            GUI_SCALE = 1.0f;
        }
        class_243 eye = GuiHandler.DH.vrPlayer.vrdata_world_render.getEye(GuiHandler.DH.currentPass).getPosition();
        class_243 translation = guipos.method_1020(eye);
        poseMatrix.translate((float)translation.field_1352, (float)translation.field_1351, (float)translation.field_1350);
        poseMatrix.mul((Matrix4fc)guirot);
        poseMatrix.translate(guilocal.x, guilocal.y, guilocal.z);
        GUI_SCALE_APPLIED = scale;
        GUI_OFFSET_LOCAL.set((Vector3fc)guilocal).div(GuiHandler.DH.vrPlayer.vrdata_world_render.worldScale);
        float thescale = scale * GuiHandler.DH.vrPlayer.vrdata_world_render.worldScale;
        poseMatrix.scale(thescale, thescale, thescale);
        GUI_RENDER_POS_ROOM = VRPlayer.worldToRoomPos(guipos, GuiHandler.DH.vrPlayer.vrdata_world_render);
        GUI_RENDER_ROTATION_ROOM.rotationY(-GuiHandler.DH.vrPlayer.vrdata_world_render.rotation_radians).mul((Matrix4fc)guirot);
        class_10209.method_64146().method_15407();
        return guipos;
    }

    static {
        KEY_LEFT_CLICK = new class_304("vivecraft.key.guiLeftClick", -1, VivecraftVRMod.INSTANCE.categoryGui);
        KEY_RIGHT_CLICK = new class_304("vivecraft.key.guiRightClick", -1, VivecraftVRMod.INSTANCE.categoryGui);
        KEY_MIDDLE_CLICK = new class_304("vivecraft.key.guiMiddleClick", -1, VivecraftVRMod.INSTANCE.categoryGui);
        KEY_SHIFT = new class_304("vivecraft.key.guiShift", -1, VivecraftVRMod.INSTANCE.categoryGui);
        KEY_CTRL = new class_304("vivecraft.key.guiCtrl", -1, VivecraftVRMod.INSTANCE.categoryGui);
        KEY_ALT = new class_304("vivecraft.key.guiAlt", -1, VivecraftVRMod.INSTANCE.categoryGui);
        KEY_SCROLL_UP = new class_304("vivecraft.key.guiScrollUp", -1, VivecraftVRMod.INSTANCE.categoryGui);
        KEY_SCROLL_DOWN = new class_304("vivecraft.key.guiScrollDown", -1, VivecraftVRMod.INSTANCE.categoryGui);
        KEY_SCROLL_AXIS = new class_304("vivecraft.key.guiScrollAxis", -1, VivecraftVRMod.INSTANCE.categoryGui);
        KEY_KEYBOARD_CLICK = new HandedKeyBinding("vivecraft.key.keyboardClick", -1, VivecraftVRMod.INSTANCE.categoryKeyboard){

            @Override
            public boolean isPriorityOnController(ControllerType type) {
                if (KeyboardHandler.SHOWING && !GuiHandler.DH.vrSettings.physicalKeyboard) {
                    return KeyboardHandler.isUsingController(type);
                }
                return RadialHandler.isShowing() && RadialHandler.isUsingController(type);
            }
        };
        KEY_KEYBOARD_SHIFT = new HandedKeyBinding("vivecraft.key.keyboardShift", -1, VivecraftVRMod.INSTANCE.categoryKeyboard){

            @Override
            public boolean isPriorityOnController(ControllerType type) {
                if (KeyboardHandler.SHOWING) {
                    return GuiHandler.DH.vrSettings.physicalKeyboard || KeyboardHandler.isUsingController(type);
                }
                return RadialHandler.isShowing() && RadialHandler.isUsingController(type);
            }
        };
        GUI_FRAMEBUFFER = null;
        GUI_APPEAR_OVER_BLOCK_ACTIVE = false;
        GUI_SCALE = 1.0f;
        GUI_SCALE_APPLIED = 1.0f;
        GUI_POS_ROOM = null;
        GUI_ROTATION_ROOM = null;
        GUI_RENDER_POS_ROOM = null;
        GUI_OFFSET_LOCAL = new Vector3f();
        GUI_RENDER_ROTATION_ROOM = new Matrix4f();
        GUI_ROTATION_PLAYER_MODEL = new Matrix4f();
        GUI_POS_PLAYER_MODEL = class_243.field_1353;
        GUI_WIDTH = 1280;
        GUI_HEIGHT = 720;
        GUI_SCALE_FACTOR = GuiHandler.calculateScale(0, false, GUI_WIDTH, GUI_HEIGHT);
        PREVIOUS_GUI_SCALE = -1;
    }
}

