/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.gui.framework.widgets;

import com.google.common.collect.ImmutableList;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4069;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_7417;
import net.minecraft.class_7919;
import net.minecraft.class_8016;
import net.minecraft.class_8023;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.tuple.Pair;
import org.vivecraft.client.gui.framework.widgets.GuiVROptionSlider;
import org.vivecraft.client.gui.framework.widgets.TextOnlyButton;
import org.vivecraft.client.utils.StringSimilarity;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.common.utils.TooltipUtil;
import org.vivecraft.server.ServerNetworking;
import org.vivecraft.server.config.ConfigBuilder;

public class SettingsList
extends class_4265<BaseEntry> {
    private final List<BaseEntry> allEntries;
    private String activeFilter = "";
    private final class_437 parent;

    public SettingsList(class_437 parent, class_310 minecraft, List<BaseEntry> entries, boolean searchable) {
        super(minecraft, parent.field_22789, parent.field_22790 - (searchable ? 74 : 52), searchable ? 42 : 20, 20);
        this.parent = parent;
        entries = entries.stream().filter(Objects::nonNull).toList();
        this.allEntries = new ArrayList<BaseEntry>(entries);
        this.replaceEntriesFlatten(this.allEntries);
    }

    public void setActive(boolean active) {
        this.field_22763 = active;
        this.allEntries.forEach(entry -> entry.setParentActive(active));
    }

    private void replaceEntriesFlatten(List<BaseEntry> entries) {
        this.replaceEntriesFlatten(entries.stream());
    }

    private void replaceEntriesFlatten(Stream<BaseEntry> entries) {
        this.method_25314(entries.flatMap(entry -> entry.getEntries().stream()).toList());
    }

    public String getActiveFilter() {
        return this.activeFilter;
    }

    public void filter(String filter) {
        if (ClientDataHolderVR.getInstance().vrSettings.useFuzzySearch) {
            this.fuzzyFilter(filter);
        } else {
            this.exactFilter(filter);
        }
    }

    private void exactFilter(String filter) {
        if (!filter.trim().equals(this.activeFilter)) {
            this.method_44382(0.0);
            String lowerCase = filter.trim().toLowerCase();
            this.replaceEntriesFlatten(this.allEntries.stream().filter((? super T entry) -> entry.filter(lowerCase)));
        }
        this.activeFilter = filter.trim();
    }

    private void fuzzyFilter(String filter) {
        if (filter.trim().isEmpty()) {
            this.replaceEntriesFlatten(this.allEntries);
        } else if (!filter.trim().equals(this.activeFilter)) {
            this.method_44382(0.0);
            String lowerCase = filter.trim().toLowerCase();
            List<BaseEntry> entries = this.allEntries.stream().flatMap(child -> child.getEntries().stream()).filter((? super T entry) -> !(entry instanceof CategoryEntry)).map(entry -> Pair.of((Object)Float.valueOf(entry.search(lowerCase)), (Object)entry)).filter((? super T pair) -> ((Float)pair.getLeft()).floatValue() > 0.7f).sorted((a, b) -> ((Float)b.getLeft()).compareTo((Float)a.getLeft())).map(Pair::getRight).toList();
            this.method_25314(entries);
        }
        this.activeFilter = filter.trim();
    }

    public boolean isEntryVisible(BaseEntry entry) {
        int index = this.method_25396().indexOf((Object)entry);
        return this.method_25337(index) < this.method_55443() && this.method_25319(index) > this.method_46427();
    }

    protected int method_65507() {
        return this.method_31383() + 2;
    }

    public int method_25322() {
        return Math.min(this.parent.field_22789 - 30, 350);
    }

    public int method_25342() {
        return this.method_46426() + this.field_22758 / 2 - this.method_25322() / 2 + 2;
    }

    public int getItemHeight() {
        return this.field_62109;
    }

    public BaseEntry getHovered() {
        return (BaseEntry)super.method_37019();
    }

    public static BaseEntry ConfigToEntry(ConfigBuilder.ConfigValue<?> configValue) {
        ResettableEntry entry = new ResettableEntry((class_2561)class_2561.method_43471((String)("vivecraft.serverSettings." + configValue.getPath())), configValue);
        ((BaseEntry)entry).setActive(class_310.method_1551().field_1687 == null || class_310.method_1551().method_1542());
        return entry;
    }

    public static BaseEntry vrOptionToEntry(VRSettings.VrOptions option) {
        ClientDataHolderVR dh = ClientDataHolderVR.getInstance();
        String optionString = "vivecraft.options." + option.name();
        WidgetEntry entry = dh.vrSettings.hasValue(option) ? new ResettableEntry((class_2561)class_2561.method_43471((String)optionString), option) : new WidgetEntry((class_2561)class_2561.method_43471((String)optionString), SettingsList.vrOptionToWidget(option, 145), () -> TooltipUtil.getClientConfigTooltip(option), null);
        if (dh.vrSettings.overrides.hasSetting(option) && dh.vrSettings.overrides.getSetting(option).isValueOverridden()) {
            ((BaseEntry)entry).setActive(false);
        }
        return entry;
    }

    private static class_339 vrOptionToWidget(VRSettings.VrOptions option, int width) {
        ClientDataHolderVR dh = ClientDataHolderVR.getInstance();
        GuiVROptionSlider widget = option.getEnumFloat() ? new GuiVROptionSlider(option.returnEnumOrdinal(), 0, 0, width, 20, option, true) : class_4185.method_46430((class_2561)class_2561.method_43470((String)dh.vrSettings.getButtonDisplayString(option, true)), button -> {
            dh.vrSettings.setOptionValue(option);
            button.method_25355((class_2561)class_2561.method_43470((String)dh.vrSettings.getButtonDisplayString(option, true)));
        }).method_46437(width, 20).method_46431();
        return widget;
    }

    public static abstract class BaseEntry
    extends class_4265.class_4266<BaseEntry> {
        protected final class_2561 name;
        private final Supplier<String> tooltip;
        private boolean active = true;
        private boolean parentActive = true;

        public BaseEntry(class_2561 name, Supplier<String> tooltipSupplier) {
            this.name = name;
            this.tooltip = tooltipSupplier == null ? () -> "" : tooltipSupplier;
        }

        public void method_25343(class_332 guiGraphics, int mouseX, int mouseY, boolean hovering, float partialTick) {
            if (this.method_25370() && class_310.method_1551().method_48186().method_48183() || hovering && class_310.method_1551().method_48186().method_48182()) {
                guiGraphics.method_25294(this.method_46426(), this.method_73382(), this.method_73389(), this.method_73382() + this.method_25364(), Integer.MIN_VALUE);
            }
        }

        public class_8016 method_48208(class_8023 event, int index) {
            if (!this.isActive()) {
                return class_8016.method_48193((class_364)this);
            }
            class_8016 componentPath = null;
            for (int i = Math.min(index, this.method_25396().size() - 1); componentPath == null && i >= 0; --i) {
                componentPath = ((class_364)this.method_25396().get(i)).method_48205(event);
            }
            return class_8016.method_48192((class_4069)this, componentPath);
        }

        protected int textColor() {
            return this.isActive() ? -1 : -6250336;
        }

        public boolean isActive() {
            return this.active && this.parentActive;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public void setParentActive(boolean active) {
            this.parentActive = active;
        }

        public boolean filter(String filter) {
            boolean match = false;
            class_7417 class_74172 = this.name.method_10851();
            if (class_74172 instanceof class_2588) {
                class_2588 trans = (class_2588)class_74172;
                match = trans.method_11022().toLowerCase().contains(filter);
            }
            return match || this.name.getString().toLowerCase().contains(filter);
        }

        public float search(String search) {
            float matchKey = 0.0f;
            class_7417 class_74172 = this.name.method_10851();
            if (class_74172 instanceof class_2588) {
                class_2588 trans = (class_2588)class_74172;
                matchKey = StringSimilarity.partial_ratio(search, trans.method_11022().toLowerCase()) * 0.9f;
            }
            float matchString = StringSimilarity.partial_ratio(search, this.name.getString().toLowerCase());
            return Math.max(matchString, matchKey);
        }

        public List<BaseEntry> getEntries() {
            return ImmutableList.of((Object)((Object)this));
        }

        public String getTooltip() {
            return this.tooltip.get();
        }
    }

    public static class ResettableEntry
    extends WidgetEntry {
        public static final int VALUE_BUTTON_WIDTH = 125;
        private final class_4185 resetButton;
        private final BooleanSupplier canReset;

        public ResettableEntry(class_2561 name, ConfigBuilder.ConfigValue<?> configValue) {
            this(name, configValue.getWidget(125, 20).get(), () -> TooltipUtil.getServerConfigTooltip(configValue.getPath(), true), null, () -> !configValue.isDefault(), () -> {
                configValue.reset();
                if (class_310.method_1551().method_1496()) {
                    configValue.onUpdate((MinecraftServer)class_310.method_1551().method_1576());
                    ServerNetworking.sendUpdatePacketToAll((MinecraftServer)class_310.method_1551().method_1576(), configValue);
                }
                return configValue.getWidget(125, 20).get();
            });
        }

        public ResettableEntry(class_2561 name, VRSettings.VrOptions option) {
            this(name, SettingsList.vrOptionToWidget(option, 125), () -> TooltipUtil.getClientConfigTooltip(option), () -> {
                VRSettings.ServerOverrides overrides = ClientDataHolderVR.getInstance().vrSettings.overrides;
                return option.isChangeable() && (!overrides.hasSetting(option) || !overrides.getSetting(option).isValueOverridden());
            }, () -> !ClientDataHolderVR.getInstance().vrSettings.isDefault(option), () -> {
                ClientDataHolderVR.getInstance().vrSettings.loadDefault(option);
                return SettingsList.vrOptionToWidget(option, 125);
            });
        }

        private ResettableEntry(class_2561 name, class_339 widget, Supplier<String> tooltipSupplier, BooleanSupplier isActive, BooleanSupplier canReset, Supplier<class_339> resetAction) {
            super(name, widget, tooltipSupplier, isActive);
            this.canReset = canReset;
            this.resetButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"X"), button -> {
                this.valueWidget = (class_339)resetAction.get();
            }).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"controls.reset"))).method_46434(0, 0, 20, 20).method_46431();
            this.resetButton.method_47402(Duration.ofMillis(-1L));
        }

        @Override
        public void method_25343(class_332 guiGraphics, int mouseX, int mouseY, boolean hovering, float partialTick) {
            super.method_25343(guiGraphics, mouseX, mouseY, hovering, partialTick);
            this.resetButton.method_46421(this.method_73389() - 20);
            this.resetButton.method_46419(this.method_73382());
            this.resetButton.field_22763 = this.isActive() && this.valueWidget.field_22763 && this.canReset.getAsBoolean();
            this.resetButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        }

        @Override
        public List<? extends class_364> method_25396() {
            return ImmutableList.of((Object)this.valueWidget, (Object)this.resetButton);
        }

        @Override
        public List<? extends class_6379> method_37025() {
            return ImmutableList.of((Object)this.valueWidget, (Object)this.resetButton);
        }

        @Override
        public void setActive(boolean active) {
            super.setActive(active);
            this.resetButton.field_22763 = active;
        }
    }

    public static class WidgetEntry
    extends BaseEntry {
        public static final int VALUE_BUTTON_WIDTH = 145;
        protected final BooleanSupplier widgetActive;
        protected class_339 valueWidget;

        public WidgetEntry(class_2561 name, class_339 valueWidget, Supplier<String> tooltipSupplier, BooleanSupplier widgetActive) {
            super(name, tooltipSupplier);
            this.valueWidget = valueWidget;
            this.widgetActive = widgetActive == null ? () -> true : widgetActive;
        }

        public WidgetEntry(class_2561 name, class_339 valueWidget, Supplier<String> tooltipSupplier) {
            this(name, valueWidget, tooltipSupplier, null);
        }

        public WidgetEntry(class_2561 name, class_339 valueWidget) {
            this(name, valueWidget, null, null);
        }

        @Override
        public void method_25343(class_332 guiGraphics, int mouseX, int mouseY, boolean hovering, float partialTick) {
            super.method_25343(guiGraphics, mouseX, mouseY, hovering, partialTick);
            int textWidth = class_310.method_1551().field_1772.method_27525((class_5348)this.name);
            int n = this.method_46427() + this.method_25364() / 2;
            Objects.requireNonNull(class_310.method_1551().field_1772);
            int textY = n - 9 / 2 + 2;
            if (textWidth < this.method_73387() - 145) {
                guiGraphics.method_27535(class_310.method_1551().field_1772, this.name, this.method_73380(), textY, this.textColor());
            } else {
                class_327 class_3272 = class_310.method_1551().field_1772;
                int n2 = this.method_73380();
                int n3 = this.method_73389() - 145 - 5;
                Objects.requireNonNull(class_310.method_1551().field_1772);
                SettingsList.method_52718((class_332)guiGraphics, (class_327)class_3272, (class_2561)this.name, (int)n2, (int)textY, (int)n3, (int)(textY + 9 - 1), (int)this.textColor());
            }
            this.valueWidget.method_46421(this.method_73389() - 145);
            this.valueWidget.method_46419(this.method_73382());
            this.valueWidget.field_22763 = this.widgetActive.getAsBoolean() && this.isActive();
            this.valueWidget.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        }

        public List<? extends class_364> method_25396() {
            return ImmutableList.of((Object)this.valueWidget);
        }

        public List<? extends class_6379> method_37025() {
            return ImmutableList.of((Object)this.valueWidget);
        }

        @Override
        public void setActive(boolean active) {
            super.setActive(active);
            this.valueWidget.field_22763 = active;
        }
    }

    public static class CategoryEntry
    extends BaseEntry {
        private final int width;

        public CategoryEntry(class_2561 name) {
            super(name, null);
            this.width = class_310.method_1551().field_1772.method_27525((class_5348)this.name);
        }

        @Override
        public void method_25343(class_332 guiGraphics, int mouseX, int mouseY, boolean hovering, float partialTick) {
            class_327 class_3272 = class_310.method_1551().field_1772;
            int n = class_310.method_1551().field_1755.field_22789 / 2 - this.width / 2;
            int n2 = this.method_73386();
            Objects.requireNonNull(class_310.method_1551().field_1772);
            guiGraphics.method_27535(class_3272, this.name, n, n2 - 9 - 1, this.textColor());
        }

        @Nullable
        public class_8016 method_48205(class_8023 event) {
            return null;
        }

        public List<? extends class_364> method_25396() {
            return Collections.emptyList();
        }

        public List<? extends class_6379> method_37025() {
            return ImmutableList.of((Object)new class_6379(){

                public class_6379.class_6380 method_37018() {
                    return class_6379.class_6380.field_33785;
                }

                public void method_37020(class_6382 narrationElementOutput) {
                    narrationElementOutput.method_37034(class_6381.field_33788, name);
                }
            });
        }
    }

    public static class ScreenEntry
    extends WidgetEntry {
        public ScreenEntry(String langKey, Function<class_437, class_437> screenFunction) {
            super((class_2561)class_2561.method_43471((String)langKey), (class_339)class_4185.method_46430((class_2561)class_2561.method_43471((String)langKey), b -> class_310.method_1551().method_1507((class_437)screenFunction.apply(class_310.method_1551().field_1755))).method_46437(145, 20).method_46431(), () -> class_1074.method_4663((String)(langKey + ".tooltip")) ? class_1074.method_4662((String)(langKey + ".tooltip"), (Object[])new Object[0]) : "");
        }
    }

    public static class SelectableEntry
    extends BaseEntry {
        private final class_339 mainWidget;
        private final class_339 optionalWidget;

        public SelectableEntry(class_2561 name, class_339 optionalWidget, Runnable callback) {
            super(name, null);
            this.mainWidget = new TextOnlyButton(name, button -> callback.run());
            this.optionalWidget = optionalWidget;
        }

        @Override
        public void method_25343(class_332 guiGraphics, int mouseX, int mouseY, boolean hovering, float partialTick) {
            super.method_25343(guiGraphics, mouseX, mouseY, hovering, partialTick);
            this.mainWidget.method_46421(this.method_73380());
            this.mainWidget.method_46419(this.method_73382());
            this.mainWidget.method_25358(this.optionalWidget == null ? this.method_73387() : this.method_73387() - 10 - this.optionalWidget.method_25368());
            this.mainWidget.method_25394(guiGraphics, mouseX, mouseY, partialTick);
            if (this.optionalWidget != null) {
                this.optionalWidget.method_46421(this.method_73389() - this.optionalWidget.method_25368());
                this.optionalWidget.method_46419(this.method_73382());
                this.optionalWidget.method_25394(guiGraphics, mouseX, mouseY, partialTick);
            }
        }

        public List<? extends class_364> method_25396() {
            return this.optionalWidget != null ? ImmutableList.of((Object)this.mainWidget, (Object)this.optionalWidget) : ImmutableList.of((Object)this.mainWidget);
        }

        public List<? extends class_6379> method_37025() {
            return this.optionalWidget != null ? ImmutableList.of((Object)this.mainWidget, (Object)this.optionalWidget) : ImmutableList.of((Object)this.mainWidget);
        }

        @Override
        public void setActive(boolean active) {
            this.mainWidget.field_22763 = active;
            if (this.optionalWidget != null) {
                this.optionalWidget.field_22763 = active;
            }
        }
    }

    public static class GroupedEntry
    extends CategoryEntry {
        private final ArrayList<BaseEntry> allChildren = new ArrayList();
        private final ArrayList<BaseEntry> activeChildren = new ArrayList();

        public GroupedEntry(class_2561 name) {
            super(name);
        }

        public void add(BaseEntry entry) {
            this.allChildren.add(entry);
            this.activeChildren.add(entry);
        }

        @Override
        public boolean filter(String filter) {
            this.activeChildren.clear();
            if (super.filter(filter)) {
                this.activeChildren.addAll(this.allChildren);
            } else {
                this.activeChildren.addAll(this.allChildren.stream().filter((? super T entry) -> entry.filter(filter)).toList());
            }
            return !this.activeChildren.isEmpty();
        }

        @Override
        public List<BaseEntry> getEntries() {
            return Stream.concat(Stream.of(this), this.activeChildren.stream().flatMap(child -> child.getEntries().stream())).toList();
        }

        @Override
        public void setParentActive(boolean active) {
            super.setParentActive(active);
            this.allChildren.forEach(child -> child.setParentActive(active));
        }
    }
}

